//
//  GMPushMsgObject.h
//  Pods
//
//  Created by wangyang on 16/8/9.
//
//

#import <Foundation/Foundation.h>

/**
 会话类型
 @author 汪洋 16-08-09 in 6.3.0
 */
typedef NS_ENUM(NSInteger, GMPushMsgType) {
    /**
     普通私信
     @author 汪洋 16-08-09 in 6.3.0
     */
    GMPushMsgTypeNormal = 1,
    /**
     客服私信
     @author 汪洋 16-08-09 in 6.3.0
     */
    GMPushMsgTypeCustomerService = 2
};

@interface GMPushMsgObject : GMObject
/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 普通私信的时候，请求http需要传给服务器的一个用户标识
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSString *userKey;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 每一项聊天信息的业务ID
 *
 *  @since 5.9.4
 */
@property(nonatomic , assign) NSInteger msgId;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 会话类型。 value：1.普通聊天 2.客服聊天
 *
 *  @since 5.9.4
 */
@property(nonatomic , assign) GMPushMsgType conversationType;
@end
