//
//  GMPushObject.h
//  Gengmei
//
//  Created by 翟国钧 on 16/4/28.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <GMBase/GMObject.h>

typedef NS_ENUM(NSInteger, GMPushType){
    GMPushTypeDefault = 1,
    GMPushTypeMsg = 2,
    GMPushTypeCtrl = 3,
};


/**
 注意，GMPushObject 使用的是自定义解析，没有使用JSONModal
 */
@interface GMPushObject : NSObject
-(instancetype)initWithDictionary:(NSDictionary*)dic;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 推送类型标识。value：1.普通推送（原有逻辑）2.私信 3.状态控制
 *
 *  @since 5.9.4
 */
@property(nonatomic , assign) GMPushType type;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 普通推送要进行业务处理的更美协议
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSString *pushUrl;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 推送业务消息
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSDictionary *msg;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 控制类型的消息体
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSDictionary *ctrl;

@end
