//
//  ALRankListCell.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/9.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankListCell.h"
#import "NSString+GM.h"
#import "ALShareSheet.h"

#define kSmallImageViewWH 40
#define kBiglImageViewWH 52
#define kSoBigCircleWH    60
#define kPickButtonW 53
@interface ALRankListCell()
@property (nonatomic, strong) GMLabel *rankLabel;

@property (nonatomic, strong) GMImageView *userImageView;
@property (nonatomic, strong) GMView *iconCircleView;

@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *rankCountLabel;

@property (nonatomic, strong) GMButton *pickButton;
@property (nonatomic, strong) GMButton *larenButton;


@end
@implementation ALRankListCell

- (void)setup {
    [super setup];
    self.backgroundColor = RGBCOLOR_HEX(0xffffff);
    self.bottomLine.hidden = NO;

    [self updateBottomLineConstraintsWithLeft:15 right:-15];
    // rank 级别
    GMLabel *rankLabel = [GMLabel labelWithTextColor:UIColor.headlineText
                                            fontSize:13];
    rankLabel.textAlignment = NSTextAlignmentCenter;
    rankLabel.verticalAlignment = GMLabelVerticalAlignmentMiddle;
    [self.contentView addSubview:rankLabel];
    self.rankLabel = rankLabel;
    
    GMView *iconCircleView = [GMView new];
    iconCircleView.layer.masksToBounds = YES;
    iconCircleView.layer.borderWidth = 2.0f;
    iconCircleView.layer.borderColor = RGBCOLOR_HEX(0x6CCDFF).CGColor;
    [self.contentView  addSubview:iconCircleView];
    self.iconCircleView = iconCircleView;
    
    GMImageView *userImageView = [GMImageView new];
    userImageView.layer.masksToBounds = YES;
    userImageView.layer.cornerRadius = kBiglImageViewWH/2;
    userImageView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
    [self.contentView  addSubview:userImageView];
    self.userImageView = userImageView;
    
    // 名字
    GMLabel *nameLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x464646)
                                            fontSize:17];
    [self.contentView addSubview:nameLabel];
    self.nameLabel = nameLabel;
    
    // pick 数
    GMLabel *rankCountLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999)
                                                 fontSize:14];
    [self.contentView addSubview:rankCountLabel];
    self.rankCountLabel = rankCountLabel;
    
    // Pick
    GMButton *pickButton = [GMButton buttonWithTitle:@"Pick!"
                                     backgroundColor:UIColor.whiteColor titleFontSize:13 titleColor:RGBCOLOR_HEX(0x0093FF)];
    pickButton.titleLabel.font = [UIFont gmFont:13];
    pickButton.layer.masksToBounds = YES;
    pickButton.layer.borderWidth = ONE_PIXEL;
    pickButton.layer.cornerRadius = 13.0f;
    pickButton.layer.borderColor = RGBCOLOR_HEX(0x0093FF).CGColor;
    [pickButton addTarget:self action:@selector(pickButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView addSubview:pickButton];
    self.pickButton = pickButton;
    
    // Pick
    GMButton *larenButton = [GMButton buttonWithTitle:@"拉票"
                                      backgroundColor:RGBCOLOR_HEX(0x0093FF)
                                        titleFontSize:13 titleColor:RGBCOLOR_HEX(0xFFFFFF)];
    larenButton.titleLabel.font = [UIFont gmFont:13];
    larenButton.layer.masksToBounds = YES;
    larenButton.layer.borderWidth = ONE_PIXEL;
    larenButton.layer.cornerRadius = 13.0f;
    larenButton.layer.borderColor = RGBCOLOR_HEX(0xFFFFFF).CGColor;
    [larenButton addTarget:self action:@selector(larenButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView addSubview:larenButton];
    self.larenButton = larenButton;
    
    [self addSubViewContraints];
}

- (void)addSubViewContraints {
    __weak __typeof(self)weakSelf = self;
    [self.rankLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.height.mas_equalTo(kRankListCellH);
        make.width.mas_equalTo(40);
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
        make.height.mas_equalTo(kRankListCellH);
    }];
    
    [self.iconCircleView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.height.mas_equalTo(kBiglImageViewWH);
        make.width.mas_equalTo(kBiglImageViewWH);
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
    }];
    
    [self.userImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.height.mas_equalTo(kBiglImageViewWH);
        make.width.mas_equalTo(kBiglImageViewWH);
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
    }];
    
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_iconCircleView.mas_right).offset(8);
        make.height.mas_equalTo(24);
        make.width.mas_equalTo(50);
        make.bottom.mas_equalTo(-kRankListCellH/2);
    }];
    
    [self.rankCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_nameLabel);
        make.height.mas_equalTo(20);
        make.right.mas_equalTo(_larenButton.mas_left).offset(-10);
        make.top.mas_equalTo(_nameLabel.mas_bottom);
    }];
    
    [self.larenButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-15);
        make.height.mas_equalTo(26);
        make.width.mas_equalTo(kPickButtonW);
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
    }];
    
    [self.pickButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(_larenButton.mas_left).offset(-10);
        make.height.mas_equalTo(26);
        make.width.mas_equalTo(kPickButtonW);
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
    }];
}

- (void)setUserObject:(ALUserObject *)userObject {
    
    _userObject = userObject;
   
    [self.userImageView setImageWithUrlString:userObject.portrait placeHolder:@"user_setter_default_icon_new"];
    self.nameLabel.text = userObject.name;
    self.rankCountLabel.text = [NSString stringWithFormat:@"Pick:%@",userObject.pick_counts];
    
    
    [self addSubViewUpdateContrains];
}

- (void)addSubViewUpdateContrains {
    
    CGFloat imageViewWH = kBiglImageViewWH;
    CGFloat imageViewLeft = 15;
    CGFloat circleViewLeft = 15;
    CGFloat circleViewWH = kSoBigCircleWH;
    if (self.cellType == ALUserCellTypeSearch) {
        self.rankLabel.hidden = YES;
        self.iconCircleView.hidden = YES;
        imageViewWH = kSmallImageViewWH;
        circleViewWH = imageViewWH;
        
    } else {
        self.rankLabel.hidden = NO;
        NSInteger userIndex = [self.userObject.rank integerValue];
        self.rankLabel.attributedText = [self rankAttibute:userIndex];
        
        if (userIndex == 1 || userIndex == 2 || userIndex == 3) {
            imageViewWH = kBiglImageViewWH;
            circleViewWH = kSoBigCircleWH;
            self.iconCircleView.hidden = NO;
            self.nameLabel.font = [UIFont gmBoldFont:17];
        } else {
            imageViewWH = kSmallImageViewWH;
            circleViewWH = imageViewWH;
            self.iconCircleView.hidden = YES;
            self.nameLabel.font = [UIFont gmFont:17];
        }
        circleViewLeft = 40;
        imageViewLeft = (circleViewWH-imageViewWH)/2 + 40;
        self.iconCircleView.layer.cornerRadius = circleViewWH/2;
    }
    
    [self.iconCircleView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(circleViewLeft);
        make.width.height.mas_equalTo(circleViewWH);
    }];
    
    [self.userImageView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(imageViewWH);
        make.left.mas_equalTo(imageViewLeft);
    }];
    
    self.userImageView.layer.cornerRadius = imageViewWH/2;
    
    CGFloat limitW = MAINSCREEN_WIDTH - imageViewLeft - circleViewWH - 15 - kPickButtonW * 2 - 20;
    CGSize nameSize = [self.nameLabel.text sizeWithFont:self.nameLabel.font
                                              boundSize:CGSizeMake(limitW, MAXFLOAT)];
    
    [self.nameLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(nameSize.width);
    }];
    
    CGSize rankSize = [self.rankLabel.attributedText sizeForBoundingRectSize:CGSizeMake(40, kRankListCellH)];
    [self.rankLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(nameSize.height);
    }];
    
}

- (NSAttributedString *)rankAttibute:(NSInteger)userIndex {
    
    NSString *rankString = [NSString stringWithFormat:@"%02zd",userIndex];
    UIFont *font = [UIFont gmFont:16];
    UIColor *color = RGBCOLOR_HEX(0x999999);
    if (userIndex == 1 || userIndex == 2 || userIndex == 3) {
        font = [UIFont fontWithName:@"Haettenschweiler" size:21]?:[UIFont gmFont:16];
        color = RGBCOLOR_HEX(0x0093FF);
    }
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
    style.alignment = NSTextAlignmentCenter;
    NSAttributedString *rankAttibute = [[NSAttributedString alloc]
                                        initWithString:rankString
                                        attributes:@{NSFontAttributeName:font,
                                                     NSForegroundColorAttributeName:color,
                                                     NSParagraphStyleAttributeName:style}];
    return rankAttibute;
}



- (void)pickButtonClick {
    
    [Phobos track:@"rank_board_click_pick" attributes:@{@"business_id":SafeString(self.pick_id),
                                                        @"tab_name":SafeString(self.pickTab_name),
                                                        @"object_id":SafeString(self.userObject.pick_user_id)}];
    
    __weak __typeof(self)weakSelf = self;
    if (self.pickUserBlock) {
        self.pickUserBlock(weakSelf.userObject);
    }
}

- (void)larenButtonClick {
    
    [Phobos track:@"rank_board_click_canvass" attributes:@{@"business_id":SafeString(self.pick_id),
                                                        @"tab_name":SafeString(self.pickTab_name),
                                                        @"object_id":SafeString(self.userObject.pick_user_id)}];
    
    //  http://earth.igengmei.com/alpha/group?group_id=1&channel=Wechat&from_user_id=5
    ALShareSheet *shareSheet = [[ALShareSheet alloc] init];
    [shareSheet show];
    __weak __typeof(self)weakSelf = self;
    shareSheet.shareTypeBlock = ^(GMSharePlatform platform) {
        NSString *title = @"";
        NSString *content = @"";
        NSString *image = weakSelf.userObject.portrait;
        NSString *urlString = weakSelf.shareData.url?:@"/alpha/pick/share";
        NSString *shareUrl = [NSString stringWithFormat:@"%@%@?pick_id=%@&pick_user_id=%@",APIHOST,urlString,weakSelf.pick_id,weakSelf.userObject.pick_user_id];
        
        shareUrl = [shareUrl stringByAppendingFormat:@"&channel=%@",[GMShareSDK shareChannel:platform]];
        NSString *user_id = [NSString stringWithFormat:@"%zd",[GMLoginManager shareInstance].user.userId];
        if (![GMLoginManager shareInstance].isVisitor) {
            shareUrl = [shareUrl stringByAppendingFormat:@"&from_user_id=%@",user_id];
        }
        
        NSURL *url = [NSURL URLWithString:shareUrl];
        
        switch (platform) {
                
            case GMSharePlatformWechatSession://微信好友
                title = self.shareData.wechat.title;
                content = self.shareData.wechat.content;
                break;
            case GMSharePlatformWechatTimeline://微信朋友圈
                title = self.shareData.wechatline.title;
                content = self.shareData.wechatline.content;
                break;
            case GMSharePlatformSinaWeibo://新浪微博
                title = self.shareData.weibo.title;
                content = self.shareData.weibo.content;
                break;
            case GMSharePlatformQQFriend:
                title = self.shareData.qq.title;
                content = self.shareData.qq.content;
                break;
            default:
                return;
        }
        
        if (![GMLoginManager shareInstance].isVisitor) {
            title = [NSString stringWithFormat:@"@%@ %@",[GMLoginManager shareInstance].user.nickName,title];
        } else {
            title = [NSString stringWithFormat:@"我 %@",title];
        }
        NSMutableDictionary *mdict = [NSMutableDictionary dictionary];
        mdict[@"title"] = SafeString(title);
        mdict[@"content"] = SafeString(content);
        mdict[@"images"] = SafeString(image);
        mdict[@"url"] =  SafeString(url);
        [[GMShareSDK shareInstance] share:platform parameters:mdict onStateChanged:^(GMShareResponseState state, NSError *error) {
            if (state == GMShareResponseStateSuccess) {
                [GMHudModule toast:@"分享成功"];
            } else if(state == GMShareResponseStateCancel) {
                [GMHudModule toast:@"取消分享"];
            } else if(state == GMShareResponseStateFail) {
                [GMHudModule toast:@"分享失败"];
            }
        }];
    };
}
@end
