//
//  ALRankSearchButton.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/22.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankSearchButton.h"

@implementation ALRankSearchButton
- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        
        [self setBackgroundColor:RGBCOLOR_HEX(0xF4F3F8)];
        [self setImage:[UIImage imageNamed:@"search_left_icon"] forState:UIControlStateNormal];
        [self setTitle:@"搜索" forState:UIControlStateNormal];
        [self setTitleColor:RGBCOLOR_HEX(0x999999) forState:UIControlStateNormal];
        self.titleLabel.font = [UIFont gmFont:14];
        self.layer.masksToBounds = YES;
        self.layer.cornerRadius = 10.0f;
    }
    return self;
}

- (CGRect)imageRectForContentRect:(CGRect)contentRect {
    CGFloat imageTop = (contentRect.size.height - 12)/2;
    return CGRectMake(10, imageTop, 12, 12);
}

- (CGRect)titleRectForContentRect:(CGRect)contentRect {
    CGFloat titleWidth = contentRect.size.width - 30;
    return CGRectMake(30, 0, titleWidth, contentRect.size.height);
}
@end
