//
//  ALRankListContainerViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankListContainerViewController.h"
#import "ALRankListViewController.h"
#import "WYSegmentView+Factory.h"


@interface ALRankListContainerViewController ()
@property (nonatomic, strong) WYSegmentView *segment;
@property (nonatomic, assign) NSInteger pickIndex;

@end

@implementation ALRankListContainerViewController

- (void)initController {
    
    [super initController];
    self.viewModel = [ALPickListViewModel new];
    self.viewModel.pickType = ALPickTypeList;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.navigationBar.title = @"亚太美学榜";
    self.navigationBar.isShowShadow = NO;
    [self setupSubviews];
    [self getHomePickList];
    [self setupSegment];
    
    // 埋点
    self.pageName = @"rank_board";
    self.businessId = self.viewModel.pick_id;
    
}
- (void)backAction:(OCNavigationBarButton *)button {
    [super backAction:button];
    
    ALRankListViewController *rankCtrl = (ALRankListViewController *)self.currentController;
    [Phobos track:@"page_click_return_label" attributes:@{@"page_name":@"rank_board",
                                                          @"business_id":SafeString(rankCtrl.viewModel.pick_id),
                                                          @"tab_name":SafeString(rankCtrl.pickTab_name)
                                                          }];
}

- (void)setupSegment {
    
    __weak __typeof(self)weakSelf = self;
    _segment = [WYSegmentView dynamicSegment];
    _segment.titleTextAttributes = @{NSFontAttributeName : [UIFont gmFont:16],
                                     NSForegroundColorAttributeName : RGBCOLOR_HEX(0x666666)};
    _segment.selectedTitleTextAttributes = @{NSFontAttributeName : [UIFont gmBoldFont:16],
                                             NSForegroundColorAttributeName : [UIColor headlineText]};
    _segment.bottomLine.hidden = YES;
    _segment.frame = CGRectMake(0, OCNavigationBar.barHeight, self.view.bounds.size.width, 45);
    _segment.showIndicator = NO;
    self.childScrollViewDidEndScroll = ^(NSInteger index) {
        [weakSelf.segment setSelectedSegmentIndex:index animated:YES];
        ALRankListViewController *rankCtrl = weakSelf.childs[index];
        [rankCtrl reloadRefreshData];
        
        [Phobos track:@"rank_board_click_tab" attributes:@{@"tab_name":SafeString(rankCtrl.pickTab_name),
                                                           @"business_id":SafeString(rankCtrl.viewModel.pick_id)
                                                           }];
    };
    
    [self.view addSubview:self.childContainer];
    self.childContainerSize = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight - _segment.height);
    [self.view insertSubview:_segment aboveSubview:self.childContainer];
    
    [self.childContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_segment.mas_bottom).offset(0);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
    
    [_segment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(OCNavigationBar.barHeight);
        make.height.mas_equalTo(45);
    }];
    _segment.hidden = YES;
}

- (void)updateSegment {
    
    // 无数据不进行segment更新
    if (self.viewModel.pick_list.count == 0) {
        return;
    }
    __weak __typeof(self)weakSelf = self;
    NSMutableArray *tagArray = [NSMutableArray array];
    NSMutableArray *otherCtrlArray = [NSMutableArray array];
    
    [self getCurrentPickIndex];
    
    for (int i = 0; i < self.viewModel.pick_list.count; i++) {
        ALPickTagObject *tagObject = self.viewModel.pick_list[i];
        [tagArray addObject:tagObject.name];
        
        ALRankListViewController *rankCtrl = self.childs[i];
        if (!rankCtrl) {
            rankCtrl = [ALRankListViewController new];
        }
        rankCtrl.viewModel.refreshData = NO;
        if (i == self.pickIndex) {
            rankCtrl.viewModel.userListObject = self.viewModel.userListObject;
            rankCtrl.viewModel.shareObject = self.viewModel.shareObject;
            
        }
        if (i == 0) {
            [self setFirstController:rankCtrl];
        } else {
            [otherCtrlArray addObject:rankCtrl];
        }
        rankCtrl.viewModel.pickType = ALPickTypeList;
        rankCtrl.viewModel.pick_id = SafeString(tagObject.pick_id);
        rankCtrl.pickTab_name = tagObject.name;
    }
    
    [self addOtherController:otherCtrlArray];
    self.childScrollView.scrollEnabled = NO;
    _segment.sectionTitles = tagArray;
    _segment.hidden = NO;
    [_segment layoutSegments];
    
    [_segment setDidSelectedBlock:^(NSUInteger index) {
        ALRankListViewController *rankCtrl = weakSelf.childs[index];
        rankCtrl.viewModel.refreshData = YES;
        [weakSelf switchToChildControllerAtIndex:index];
        
        [Phobos track:@"rank_board_click_tab" attributes:@{@"tab_name":SafeString(rankCtrl.pickTab_name),
                                                           @"business_id":SafeString(rankCtrl.viewModel.pick_id)
                                                           }];
    }];
    
    // 当前点击的Pick_id
    [_segment setSelectedSegmentIndex:self.pickIndex animated:YES];
    [self switchToChildControllerAtIndex:self.pickIndex];
    
}

// 获取当前PickIndex
- (void)getCurrentPickIndex {
    
    self.pickIndex = 0;
    for (int i = 0; i < self.viewModel.pick_list.count; i++) {
        ALPickTagObject *tagObject = self.viewModel.pick_list[i];
        if ([SafeString(tagObject.pick_id) isEqualToString:self.viewModel.pick_id]) {
            self.pickIndex = i;
        }
    }
}

#pragma mark - netWork
- (void)getHomePickList {
    
    [self hideEmptyView];
    [self showLoading:nil];
    __weak __typeof(self)weakSelf = self;
    [self.viewModel excuteHomePickList:^(id responseObject) {
        [self hideLoading];
        [weakSelf updateSegment];
    } failBlock:^(NSString *message) {
        [self hideLoading];
        [self showEmptyView:GMEmptyViewTypeException];
    }];
}

- (void)emptyViewDidClickReload {
    [self getHomePickList];
}

- (void)setupSubviews {
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
