//
//  ALRankSearchViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/30.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankSearchViewController.h"
#import "ALRankContainerViewController.h"
#import "ALSearchBarView.h"
#import "ALRankListCell.h"
#import "GMTabBarController.h"

@interface ALRankSearchViewController ()<ALSearchBarViewDelegate>
/** 顶部searchBar */
@property (nonatomic, strong) ALSearchBarView *searchView;
/** 用户搜索词 */
@property (nonatomic, copy) NSString *searchString;
@end

@implementation ALRankSearchViewController

#pragma mark - lazy loading
- (ALSearchBarView *)searchView {
    if (!_searchView) {
        _searchView = [[ALSearchBarView alloc]init];
        _searchView.delegate = self;
    }
    if (!_searchView.superview) {
        [self.view addSubview:_searchView];
    }
    return _searchView;
}

- (void)initController {
    
    [super initController];
    
    self.controlNavigationByYou = NO;
    self.navigationBar.hidden = YES;
    _needHeaderRefresh = NO;
    _needFooterRefresh = NO;
    self.immediateLoad = NO;
    self.viewModel = [ALPickListViewModel new];
    self.viewModel.pickType = ALPickTypeList;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self.searchView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_offset(0);
        make.height.mas_equalTo(OCNavigationBar.barHeight);
    }];
    [_table registerCell:[ALRankListCell class]];
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return self.viewModel.userListObject.users.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    ALRankListCell *cell = [tableView dequeueCell:[ALRankListCell class] forIndexPath:indexPath];
    cell.cellType = ALUserCellTypeSearch;
    cell.userIndex = indexPath.row;
    cell.userObject = self.viewModel.userListObject.users[indexPath.row];
    cell.shareData = self.viewModel.shareObject;
    cell.pick_id = self.viewModel.pick_id;
    __weak __typeof(self)weakSelf = self;
    cell.pickUserBlock = ^(ALUserObject *userObject) {

        __block ALRankContainerViewController *rankCtrl = nil;
        [[AppDelegate navigation].viewControllers enumerateObjectsUsingBlock:^(__kindof UIViewController * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            if ([obj isKindOfClass:[ALRankContainerViewController class]]) {
                rankCtrl = ( ALRankContainerViewController *)obj;
                *stop = YES;
            }
        }];
        if (rankCtrl) {
            rankCtrl.viewModel.pick_id = weakSelf.viewModel.pick_id;
            rankCtrl.viewModel.pick_user_id = userObject.pick_user_id;
            rankCtrl.viewModel.refreshData = YES;
            [[AppDelegate navigation] popToViewController:rankCtrl animated:YES];
        } else {
            rankCtrl = (ALRankContainerViewController *)AppDelegate.tabBarController.current;
            rankCtrl.viewModel.pick_id = weakSelf.viewModel.pick_id;
            rankCtrl.viewModel.pick_user_id = userObject.pick_user_id;
            rankCtrl.viewModel.refreshData = YES;
            [[AppDelegate navigation] popToRootViewControllerAnimated:YES];
        }
    };
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return kRankListCellH;
}

#pragma mark - ALSearchBarViewDelegate
/** delegate : 返回 */
- (void)searchViewDidBack:(ALSearchBarView *)searchView {
    
    [self.navigationController popViewControllerAnimated:YES];
}
/** delegate : 搜索 或 键盘搜索 */
- (void)searchView:(ALSearchBarView *)searchView searchString:(NSString *)searchString {
    
    self.viewModel.query = searchString;
    
    [self searchPickUser];
}

- (void)searchPickUser {
   
    [self.viewModel excuteUserPickList:^(id responseObject) {
        
        if (self.viewModel.userListObject.users.count > 0) {
            [self.table reloadData];
        } else {
            [self showEmptyView:GMEmptyViewTypeEmpty];
        }
        
    } failBlock:^(NSString *message) {
        if (self.viewModel.userListObject.users.count == 0) {
            [self showEmptyView:GMEmptyViewTypeException];
        }
    }];
}
@end
