//
//  ALPickUserCountView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/16.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALPickUserCountView.h"

@interface ALPickUserCountView()
@property (nonatomic, strong) GMImageView *tagImageView;
@end

@implementation ALPickUserCountView
- (void)setup {
    [super setup];
    
    // 图片
    GMImageView *tagImageView = [GMImageView new];
    tagImageView.image = [UIImage imageNamed:@"card_user_pick_icon"];
    [self addSubview:tagImageView];
    self.tagImageView = tagImageView;
    
    // 名字
    GMLabel *pickCountLabel = [GMLabel new];
    pickCountLabel.font = [UIFont gmFont:15];
    pickCountLabel.textAlignment = NSTextAlignmentLeft;
    pickCountLabel.textColor = RGBCOLOR_HEX(0x0093FF);
    [self addSubview:pickCountLabel];
    self.pickCountLabel = pickCountLabel;
    
    __weak __typeof(self)weakSelf = self;
    [self.tagImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(15, 16));
        make.centerY.mas_equalTo(weakSelf.mas_centerY);
        make.left.mas_equalTo(0);
    }];
    
    [self.pickCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_tagImageView.mas_right).offset(3);
        make.top.bottom.right.mas_equalTo(0);
    }];
}
@end
