//
//  ALRankCardView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/9.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankCardView.h"
#import "ALRankListContainerViewController.h"
#import "ALPickUserCountView.h"
#import "MDCSwipeToChooseView.h"


#define kRandomColor [UIColor colorWithRed:arc4random_uniform(255.0) green:arc4random_uniform(255.0) blue:arc4random_uniform(255.0) alpha:1]

#define kLikeViewWH 88
@interface ALRankCardView()
@property (nonatomic, strong) GMView *userInfoView;
@property (nonatomic, strong) GMImageView *userImageView;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *rankLabel;
@property (nonatomic, strong) GMLabel *infoLabel;
@property (nonatomic, strong) GMButton *lookRankListButton;
@property (nonatomic, strong) ALPickUserCountView *userCountView;

@end
@implementation ALRankCardView

- (instancetype)initWithFrame:(CGRect)frame options:(MDCSwipeToChooseViewOptions *)options {
    if (self = [super initWithFrame:frame options:options]) {
        [self setup];
        
        self.backgroundColor = UIColor.whiteColor;
        self.layer.masksToBounds = YES;
        self.layer.borderColor = [UIColor colorWithHex:0x999999 alpha:0.5].CGColor;
        self.layer.borderWidth = 0.5f;
        /*
        self.layer.shadowOffset = CGSizeMake(0, 1);
        self.layer.shadowRadius = 8.0f;
        self.layer.shadowColor = [UIColor colorWithHex:0x000000 alpha:0.5].CGColor;*/
        self.layer.cornerRadius = 10.f;
        
        self.contentView.frame = CGRectMake(0, 0, frame.size.width,frame.size.width);
        [self bringSubviewToFront:self.contentView];
    }
    return self;
}

- (void)setup {
    
    // 图片
    
    GMImageView *userImageView = [GMImageView new];
    userImageView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
    [self addSubview:userImageView];
    self.userImageView = userImageView;
    
    // 底部View
    GMView *userInfoView = [GMView new];
    [self addSubview:userInfoView];
    self.userInfoView = userInfoView;
    
    // 名字
    GMLabel *nameLabel = [GMLabel new];
    nameLabel.font = [UIFont gmBoldFont:17];
    nameLabel.textColor = RGBCOLOR_HEX(0x4A4A4A);
    [self.userInfoView addSubview:nameLabel];
    self.nameLabel = nameLabel;
    
    // 数量View
    ALPickUserCountView *userCountView = [ALPickUserCountView new];
    [self.userInfoView addSubview:userCountView];
    self.userCountView = userCountView;
    
    // 排名
    GMLabel *rankLabel = [GMLabel new];
    [self.userInfoView addSubview:rankLabel];
    self.rankLabel = rankLabel;
    
    // 介绍
    GMLabel *infoLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight
                                            fontSize:15];
    [self.userInfoView addSubview:infoLabel];
    self.infoLabel = infoLabel;
    
    // 查看榜单
    GMButton *lookRankListButton = [GMButton buttonWithTitle:@"查看榜单"
                                             backgroundColor:RGBCOLOR_HEX(0x0093FF)
                                               titleFontSize:13
                                                  titleColor:[UIColor whiteColor]];
    lookRankListButton.titleLabel.font = [UIFont gmFont:13];
    lookRankListButton.layer.masksToBounds = YES;
    lookRankListButton.layer.cornerRadius = 12.0f;
    [lookRankListButton addTarget:self action:@selector(lookRankListButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.userInfoView addSubview:lookRankListButton];
    self.lookRankListButton = lookRankListButton;
    
    [self addSubViewContrains];
}

- (void)addSubViewContrains {
    
    [self.userImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(kRankCardViewW, kRankCardViewW));
    }];
    
    [self.userInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_userImageView.mas_bottom).offset(15);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.height.mas_equalTo(kUserInfoViewH);
    }];
    
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(0);
        make.width.mas_equalTo(80);
        make.height.mas_equalTo(kUserInfoViewH/2);
    }];
    
    [self.userCountView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_nameLabel.mas_right).offset(10);
        make.top.right.mas_equalTo(0);
        make.height.equalTo(_nameLabel);
    }];
    
    [self.rankLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.width.mas_equalTo(80);
        make.height.mas_equalTo(kUserInfoViewH/2);
    }];
    
    [self.lookRankListButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
        make.width.mas_equalTo(74);
        make.height.mas_equalTo(23);
    }];
    
    [self.infoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
//        make.top.mas_equalTo(_nameLabel.mas_bottom).offset(0);
        make.bottom.mas_equalTo(0);
        make.right.mas_equalTo(_lookRankListButton.mas_left).offset(-8);
        make.height.mas_equalTo(kUserInfoViewH/2);
    }];
}

- (void)setUserObject:(ALUserObject *)userObject {
    
    _userObject = userObject;
    [self.userImageView setImageWithUrlString:userObject.image placeHolder:@"pick_card_default"];
    self.nameLabel.text = userObject.name;
    
    if ([userObject.topic_nums isNonEmpty]) {
        self.userCountView.hidden = NO;
        self.userCountView.pickCountLabel.text = [NSString stringWithFormat:@"%@",userObject.topic_nums];
    } else {
        self.userCountView.hidden = YES;
    }
    if ([userObject.rank integerValue] != 0) {
        self.rankLabel.hidden = NO;
        NSInteger rankIndex = [userObject.rank integerValue];
        self.rankLabel.attributedText = [self rankAttibute:[NSString stringWithFormat:@"%02zd",rankIndex]];
    } else {
        self.rankLabel.hidden = YES;
    }
    // 0 用户展示城市 1明星展示简介
    if ([userObject.pick_type isEqualToString:@"0"]) {
        self.infoLabel.text = userObject.city;
    } else {
        self.infoLabel.text = userObject.subtitle;
    }
    [self addSubViewUpdateContrains];
}

- (void)addSubViewUpdateContrains {
    
    CGFloat rankW = [self.rankLabel.attributedText sizeForBoundingRectSize:CGSizeMake((kRankCardViewW-30), MAXFLOAT)].width;
    [self.rankLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(rankW);
    }];
    
    CGFloat limitW = (kRankCardViewW-30) - rankW - 10;
    if (!self.userCountView.pickCountLabel.hidden) {
        limitW = limitW - 25;
    }
    
    CGSize nameSize = [self.nameLabel.text sizeWithFont:self.nameLabel.font
                                              boundSize:CGSizeMake(limitW, MAXFLOAT)];
    [self.nameLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(nameSize);
    }];
    
    
}

- (NSAttributedString *)rankAttibute:(NSString *)rank {
    
    NSString *rankString = [NSString stringWithFormat:@"第%@名",rank];
    NSMutableAttributedString *rankAttibute = [NSAttributedString
                                        attributedStringWithString:rankString
                                        font:[UIFont gmFont:15]
                                        color:RGBCOLOR_HEX(0x0093FF)];
    NSRange range = [rankString rangeOfString:rank];
    UIFont *font = [UIFont fontWithName:@"Haettenschweiler" size:22]?:[UIFont gmBoldFont:22];
    [rankAttibute addAttributes:@{NSFontAttributeName:font}
                          range:range ];
    return rankAttibute;
}

- (void)lookRankListButtonClick {
    
    [Phobos track:@"pick_home_click_view_rankboard" attributes:@{@"tab_name":SafeString(self.pickTab_name),
                                                       @"business_id":SafeString(self.userObject.pick_user_id)
                                                       }];
    
    ALRankListContainerViewController *rankContainerCtrl = [[ALRankListContainerViewController alloc] init];
    rankContainerCtrl.viewModel.pick_id = self.pick_id?:@"";
    [AppDelegate.navigation pushViewController:rankContainerCtrl animated:YES];
}

@end
