//
//  ALPickMainViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRankContainerViewController.h"
#import "WYSegmentView+Factory.h"
#import "ALRankViewController.h"
#import "ALTopicListVController.h"
#import "ALGroupListVController.h"

@interface ALRankContainerViewController ()
@property (nonatomic, strong) GMView *pickGuideView;
@property (nonatomic, strong) WYSegmentView *segment;
@property (nonatomic, assign) NSInteger pickIndex;
@end

@implementation ALRankContainerViewController

#pragma mark - lazy loading
- (GMView *)pickGuideView {
    if (!_pickGuideView) {
        GMView *pickGuideView = [[GMView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
        pickGuideView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.6];
        
        
        GMImageView *pickGuideImageView = [[GMImageView alloc] initWithFrame:pickGuideView.bounds];
        pickGuideImageView.image = [UIImage imageNamed:@"alpha_guide_one"];
        [pickGuideView addSubview:pickGuideImageView];
        
        pickGuideView.hidden = YES;
        UITapGestureRecognizer *tagGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(pickGuideViewClick)];
        [pickGuideView addGestureRecognizer:tagGesture];
        _pickGuideView = pickGuideView;
        
    }
    if (!_pickGuideView.superview) {
        [AppDelegate.shareInstance.window addSubview:_pickGuideView];
    }
    return _pickGuideView;
}

- (void)initController {
    
    [super initController];
    
    self.pageName = @"pick_home";
    self.viewModel = [ALPickListViewModel new];
    self.viewModel.refreshData = YES;
    self.viewModel.pickType = ALPickTypeCard;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.navigationBar.title = @"Pick！";
    self.navigationBar.isShowShadow = NO;
    [self setupSegment];
    [self getHomePickList];
    
}

- (void)viewWillAppear:(BOOL)animated {
    
    [super viewWillAppear:animated];
    
    if (self.viewModel.pick_list.count > 0 && self.viewModel.refreshData) {
        // 获取当前pickIndex
        [self getCurrentPickIndex];
        ALRankViewController *rankCtrl = self.childs[self.pickIndex];
        rankCtrl.viewModel.refreshData = YES;
        rankCtrl.viewModel.pick_user_id = self.viewModel.pick_user_id;
        // 当前点击的Pick_id AND 切换承载页面
        [_segment setSelectedSegmentIndex:self.pickIndex animated:YES];
        [self switchToChildControllerAtIndex:self.pickIndex];
        self.viewModel.pick_user_id = @"";
        
    }
}

// 设置setupSegment
- (void)setupSegment {
    
    __weak __typeof(self)weakSelf = self;
    _segment = [WYSegmentView dynamicSegment];
    _segment.titleTextAttributes = @{NSFontAttributeName : [UIFont gmFont:16],
                                     NSForegroundColorAttributeName : RGBCOLOR_HEX(0x666666)};
    _segment.selectedTitleTextAttributes = @{NSFontAttributeName : [UIFont gmBoldFont:16],
                                             NSForegroundColorAttributeName : [UIColor headlineText]};
    
    _segment.bottomLine.hidden = YES;
    _segment.frame = CGRectMake(0, OCNavigationBar.barHeight, self.view.bounds.size.width, 45);
    _segment.showIndicator = NO;
    self.childScrollViewDidEndScroll = ^(NSInteger index) {
        [weakSelf.segment setSelectedSegmentIndex:index animated:YES];
        ALRankViewController *rankCtrl = weakSelf.childs[index];
        [rankCtrl reloadRefreshData];
        
        [Phobos track:@"pick_home_click_tab" attributes:@{@"tab_name":SafeString(rankCtrl.pickTab_name)}];
    };
    
    [self.view addSubview:self.childContainer];
    self.childContainerSize = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight - _segment.height);
    [self.view insertSubview:_segment aboveSubview:self.childContainer];
    
    [self.childContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_segment.mas_bottom).offset(0);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
    
    [_segment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(OCNavigationBar.barHeight);
        make.height.mas_equalTo(45);
    }];
    _segment.hidden = YES;
}

// 更新setupSegment
- (void)updateSegment {
    
    // 无数据不进行segment更新
    if (self.viewModel.pick_list.count == 0) {
        return;
    }
    __weak __typeof(self)weakSelf = self;
    NSMutableArray *otherCtrlArray = [NSMutableArray array];
    NSMutableArray *tagArray = [NSMutableArray array];

    // 获取当前pickIndex
    [self getCurrentPickIndex];
    
    for (int i = 0; i < self.viewModel.pick_list.count; i++) {

        ALPickTagObject *tagObject = self.viewModel.pick_list[i];
        [tagArray addObject:tagObject.name];

        ALRankViewController *rankCtrl = self.childs[i];
        if (!rankCtrl) {
            rankCtrl = [ALRankViewController new];
        }
        rankCtrl.viewModel.refreshData = NO;
        if (i == self.pickIndex) {
            rankCtrl.viewModel.userListObject = self.viewModel.userListObject;
            rankCtrl.viewModel.shareObject = self.viewModel.shareObject;
        }
        
        rankCtrl.viewModel.pick_id = SafeString(tagObject.pick_id);
        rankCtrl.viewModel.pickType = ALPickTypeCard;
        rankCtrl.pickTab_name = tagObject.name;

        if (i == 0) {
            [self setFirstController:rankCtrl];
        } else {
            [otherCtrlArray addObject:rankCtrl];
        }
    }
    [self addOtherController:otherCtrlArray];
    self.childScrollView.scrollEnabled = NO;
    _segment.sectionTitles = tagArray;
     _segment.hidden = NO;
    [_segment layoutSegments];

    [_segment setDidSelectedBlock:^(NSUInteger index) {
        
        ALRankViewController *rankCtrl = weakSelf.childs[index];
        rankCtrl.viewModel.refreshData = YES;
        // 当前点击的Pick_id AND 切换承载页面
        [weakSelf switchToChildControllerAtIndex:index];
        
        [Phobos track:@"pick_home_click_tab" attributes:@{@"tab_name":SafeString(rankCtrl.pickTab_name)}];
    }];
    
    
    // 当前点击的Pick_id
    [_segment setSelectedSegmentIndex:self.pickIndex animated:YES];
    [self switchToChildControllerAtIndex:self.pickIndex];
    
    CGSize size = self.childScrollView.contentSize;
    self.childScrollView.contentSize = CGSizeMake(size.width, 0);
    
    // 展示打榜引导
    [self showPickGuideView];
}

// 获取当前PickIndex
- (void)getCurrentPickIndex {
    
    self.pickIndex = 0;
    for (int i = 0; i < self.viewModel.pick_list.count; i++) {
        ALPickTagObject *tagObject = self.viewModel.pick_list[i];
        if ([SafeString(tagObject.pick_id) isEqualToString:self.viewModel.pick_id]) {
            self.pickIndex = i;
        }
    }
}

#pragma mark - PickGuideView
- (void)showPickGuideView {
    
    BOOL showPickGuide = [[[NSUserDefaults standardUserDefaults] objectForKey:kShowPickGuide] boolValue];
    if (!showPickGuide) {
        [AppDelegate.shareInstance.window bringSubviewToFront:self.pickGuideView];
        self.pickGuideView.hidden = NO;
        
        [[NSUserDefaults standardUserDefaults] setObject:@(YES) forKey:kShowPickGuide];
        [[NSUserDefaults standardUserDefaults] synchronize];
    }
}

- (void)pickGuideViewClick {
    
    self.pickGuideView.hidden = YES;
    [self.pickGuideView removeFromSuperview];
    
}


#pragma mark - netWork
- (void)getHomePickList {
    
    [self hideEmptyView];
    [self showLoading:nil];
    __weak __typeof(self)weakSelf = self;
    [self.viewModel excuteHomePickList:^(id responseObject) {
        [self hideLoading];
        weakSelf.viewModel.refreshData = NO;
        [weakSelf updateSegment];
    } failBlock:^(NSString *message) {
        [self hideLoading];
        [self showEmptyView:GMEmptyViewTypeException];
    }];
}

- (void)emptyViewDidClickReload {
    
    [self getHomePickList];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
