//
//  ALPickListViewModel.h
//  GMAlpha
//
//  Created by Mikasa on 2018/11/15.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALPickObject.h"
#import "WMShareObject.h"

typedef NS_ENUM(NSInteger, ALPickType) {
    ALPickTypeCard = 1,// 卡片
    ALPickTypeList = 0 // 列表
};// 打榜类型

@interface ALPickListViewModel : WMFetchDataViewModel

@property (nonatomic, copy) NSString *pick_id;// 打榜标签id
@property (nonatomic, copy) NSString *pick_user_id;// pick用户ID
@property (nonatomic, assign) BOOL is_pick;// 1(打榜)，0(不打榜)
@property (nonatomic, copy) NSString *pick_type;// pick类型明星，用户
@property (nonatomic, assign) ALPickType pickType;// 打榜卡片类型
@property (nonatomic, assign) BOOL refreshData;// 是否需要更新用户数据
@property (nonatomic, assign) BOOL moreData;// 是否还有更多数据
@property (nonatomic, copy) NSString *query;// 搜索关键词
@property (nonatomic, assign) NSInteger total;// 用户总数

@property (nonatomic, strong) NSArray *pick_list;
@property (nonatomic, strong) ALUserListObject *userListObject;
@property (nonatomic, strong) WMShareObject *shareObject;

/**
 执行获取打榜列表请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteHomePickList:(HttpSuccessBlock)successBlock
                 failBlock:(HttpFailedBlock)failBlock;

/**
 执行获取打榜用户列表请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteUserPickList:(HttpSuccessBlock)successBlock
                 failBlock:(HttpFailedBlock)failBlock;

/**
 执行用户打榜请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteUserDoPick:(NSString *)pick_user_id successBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;

@end
