//
//  ALPickListViewModel.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/15.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALPickListViewModel.h"

@implementation ALPickListViewModel
- (instancetype)init {
    
    if (self = [super init]) {
        
        // 默认可以获取更多数据
       self.moreData = YES;
    }
    return self;
}
/**
 执行获取打榜列表请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteHomePickList:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    
    self.userListObject = nil;
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    if ([self.pick_id isNonEmpty]) {
        [params setObject:SafeNumber(self.pick_id) forKey:@"pick_id"];
    }
    if ([self.pick_user_id isNonEmpty]) {
        [params setObject:SafeNumber(self.pick_user_id) forKey:@"pick_user_id"];
    }
    // 用来区分排序，0为按照打榜数排序（卡片页的排序方式），1为按照策略排序（列表页排序方式）, default=1
    [params setObject:SafeNumber(@(self.pickType)) forKey:@"order_by"];

    __weak __typeof(self)weakSelf = self;
    NSMutableURLRequest *request = [[GMNetworking customRequestWithApi:API_PICK_LIST
                                                                method:GMHTTPMethodGet
                                                            parameters:params] mutableCopy];
    [GMNetworking sendOC:request completion:^(GMResponseOC * _Nonnull response) {
        
        // 数据加载成功后pick_user_id 置空
        weakSelf.pick_user_id = @"";
        
        [GMHudModule hideLoading];
        if (response.isSuccess) {
            
            // 数据加载成功后pick_user_id 置空
            NSDictionary *dic = response.data;
            NSArray *pick_listArray = dic[@"pick_list"];
            weakSelf.pick_list = [ALPickTagObject arrayOfModelsFromDictionaries:pick_listArray error:nil];
            
            NSDictionary *user_listDict = dic[@"user_list"];
            ALUserListObject *userList = [[ALUserListObject alloc] initWithDictionary:user_listDict error:nil];
            if (userList.users.count < PAGE_COUNT) {
                weakSelf.moreData = NO;
            } else {
                weakSelf.moreData = YES;
            }
            if (!weakSelf.userListObject) {
                weakSelf.userListObject = userList;
            } else {
                [weakSelf.userListObject.users addObjectsFromArray:userList.users];
            }
            weakSelf.shareObject = [[WMShareObject alloc] initWithDictionary:dic[@"share_data"] error:nil];
            successBlock(response);
        } else {
            failBlock(@"");
        }
    }];
}

/**
 执行获取打榜用户列表请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteUserPickList:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    
    if (self.page == 1) {
        self.userListObject = nil;
    }
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    if ([self.pick_id isNonEmpty]) {
        [params setObject:SafeNumber(self.pick_id) forKey:@"pick_id"];
    }
    if ([self.pick_user_id isNonEmpty]) {
        [params setObject:SafeNumber(self.pick_user_id) forKey:@"pick_user_id"];
    }
    if ([self.query isNonEmpty]) {
        [params setObject:SafeString(self.query) forKey:@"query"];
    }
    
    // 用来区分排序，0为按照打榜数排序（卡片页的排序方式），1为按照策略排序（列表页排序方式）, default=1
    [params setObject:SafeNumber(@(self.pickType)) forKey:@"order_by"];
    [params setObject:@(self.page) forKey:@"page"];
    [params setObject:@(self.count) forKey:@"count"];
    
    __weak __typeof(self)weakSelf = self;
    NSMutableURLRequest *request = [[GMNetworking customRequestWithApi:API_PICK_USER_LIST
                                                                method:GMHTTPMethodGet
                                                            parameters:params] mutableCopy];
    [GMNetworking sendOC:request completion:^(GMResponseOC * _Nonnull response) {
        [GMHudModule hideLoading];
        
        // 数据加载成功后pick_user_id query置空
        weakSelf.pick_user_id = @"";
        weakSelf.query = @"";
        
        if (response.isSuccess) {
            NSDictionary *dic = (NSDictionary *)response.data;
            ALUserListObject *userListObject = [[ALUserListObject alloc] initWithDictionary:dic
                                                                                  error:nil];
            if (userListObject.users.count < PAGE_COUNT) {
                weakSelf.moreData = NO;
            } else {
                weakSelf.moreData = YES;
            }
            if (!weakSelf.userListObject) {
                weakSelf.userListObject = userListObject;
                weakSelf.total = [dic[@"total"] integerValue];
            } else {
                [weakSelf.userListObject.users addObjectsFromArray:userListObject.users];
            }
            weakSelf.shareObject = [[WMShareObject alloc]initWithDictionary:dic[@"share_data"] error:nil];
            successBlock(response);
        } else {
            failBlock(@"");
        }
    }];
}

/**
 执行用户打榜请求
 
 @param successBlock
 @param failBlock
 */
- (void)excuteUserDoPick:(NSString *)pick_user_id successBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    
    NSMutableDictionary *params = [NSMutableDictionary dictionary];
    [params setObject:SafeString(pick_user_id) forKey:@"pick_user_id"];
    [params setObject:SafeNumber(@(self.is_pick)) forKey:@"is_pick"];
    [params setObject:SafeNumber(self.pick_type) forKey:@"pick_type"];
   
    
    NSMutableURLRequest *request = [[GMNetworking customRequestWithApi:API_PICK_DO_PICK
                                                                method:GMHTTPMethodPost
                                                            parameters:params] mutableCopy];
    __weak __typeof(self)weakSelf = self;
    [GMNetworking sendOC:request completion:^(GMResponseOC * _Nonnull response) {
        
        // 执行后清除数据
        weakSelf.pick_user_id = @"";
        
        if (response.isSuccess) {
            successBlock(response);
        } else {
            failBlock(@"");
        }
    }];
}

@end
