
//
//  ALHomeSearchBarView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSearchBarView.h"

@interface ALSearchBarView() <UISearchBarDelegate>
@property (nonatomic, strong) UIButton *backButton;
@property (nonatomic, strong) UISearchBar *searchBar;

@end

@implementation ALSearchBarView

- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.whiteColor;
    [self addSubview:self.backButton];
    [self addSubview:self.searchBar];
    [self.backButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(45, 44));
    }];
    
    [self.searchBar mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_greaterThanOrEqualTo(20);
        make.bottom.mas_equalTo(-7);
        make.right.mas_equalTo(0);
        make.height.mas_equalTo(30);
        make.left.equalTo(self.backButton.mas_right);
    }];
}

/** action: 返回 */
- (void)clickedBackButton:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(searchViewDidBack:)]) {
        [self.delegate searchViewDidBack:self];
    }
}

#pragma mark - searchBar.delegate
/** searchBar.delegate 检测到 键盘上搜索点击 */
- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
    [searchBar resignFirstResponder];
    NSString *text = searchBar.text;
    if ([self.delegate respondsToSelector:@selector(searchView:searchString:)]) {
        [self.delegate searchView:self searchString:text];
    }
}

/** 点击了searchBar的取消按钮, 这里用于 点击了 搜索 */
- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
    [searchBar resignFirstResponder];
    NSString *text = searchBar.text;
    if ([self.delegate respondsToSelector:@selector(searchView:searchString:)]) {
        [self.delegate searchView:self searchString:text];
    }
}

#pragma mark - getter
- (UIButton *)backButton
{
    if (_backButton == nil) {
        _backButton = [[UIButton alloc] init];
        [_backButton setImage:[UIImage imageNamed:@"nav_back"] forState:UIControlStateNormal];
        [_backButton addTarget:self action:@selector(clickedBackButton:) forControlEvents:UIControlEventTouchDown];
    }
    [_backButton sizeToFit];
    return _backButton;
}

- (UISearchBar *)searchBar {
    if (!_searchBar) {
        _searchBar = [[UISearchBar alloc] init];
        _searchBar.barStyle = UIBarStyleDefault;
        _searchBar.delegate = self;
        _searchBar.searchTextPositionAdjustment = UIOffsetMake(2, 0);
        //1.🔍图片更改
        UIImage *searchIcon = [UIImage imageNamed:@"search_left_icon"];
        [_searchBar setImage:searchIcon forSearchBarIcon:UISearchBarIconSearch state:UIControlStateNormal];
        //2.提示语
        _searchBar.placeholder = @"搜索";
        //3.背景颜色
        UIImage *bkImg = [UIImage imageWithColor:UIColor.whiteColor];
        [_searchBar setBackgroundImage:bkImg forBarPosition:UIBarPositionAny barMetrics:UIBarMetricsDefault];
        //4.取消按钮
        _searchBar.showsCancelButton = YES;
        //3.textField背景颜色, 搜索按钮
        for (UIView *view in _searchBar.subviews.lastObject.subviews) {
            if ([view isKindOfClass:NSClassFromString(@"UISearchBarTextField")]) {
                UITextField *textField = (UITextField *)view;
                textField.font = [UIFont gmFont:14];
                textField.textColor = RGBCOLOR_HEX(0x464646);
                textField.layer.cornerRadius = 5.0f;
                textField.clipsToBounds = YES;
                textField.backgroundColor = RGBCOLOR_HEX(0xF4F3F8);
            }
            if ([view isKindOfClass:NSClassFromString(@"UINavigationButton")]) {
                UIButton *cancelButton = (UIButton *)view;
                cancelButton.layer.cornerRadius = 5.0f;
                cancelButton.clipsToBounds = YES;
                [cancelButton setTitle:@"搜索" forState:UIControlStateNormal];
                [cancelButton setTitleColor:RGBCOLOR_HEX(0x2D9AFF) forState:UIControlStateNormal];
            }
        }
    }
    return _searchBar;
}

@end

