//
//  ALHomeSearchViewModel.m
//  GMAlpha
//
//  Created by zhb on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALHomeSearchViewModel.h"

@interface ALHomeSearchViewModel ()
@property (nonatomic, copy) NSString *searchString;
@property (nonatomic, strong) ALHomeSearchModel *contentObject;

@end


@implementation ALHomeSearchViewModel
- (instancetype)init
{
    self = [super init];
    if (self) {
        _searchString = @"";
        _remoteUrl = API_V1_SEARCH;
//        self.httpMethod = HttpMethodGet;
    }
    return self;
}

- (void)buildParams{
    _params = @{
                @"query":self.searchString,
                @"page":@(self.page),
                @"couont":@(10)
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *contentData = dic[@"data"];
    NSError *error = nil;
    self.contentObject = [[ALHomeSearchModel alloc] initWithDictionary:contentData error:&error];
    if (self.contentObject.cards == nil || [self.contentObject.cards isKindOfClass:[NSNull class]]) return;

    [self.dataArray addObjectsFromArray:self.contentObject.cards];
}


- (void)fetchRemoteDataWithSearchString:(NSString *)searchString {
    self.searchString = searchString;
    self.page = 1;
    [self fetchRemoteData];
}

@end
