//
//  ALCreateTopicCell.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/7.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "ALCreateTopicCell.h"

@implementation ALCreateTopicCell

- (void)setup {
    [super setup];

    _nameLabel = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:15];
    _nameLabel.text = @"种草研究室";
    [self.contentView addSubview: _nameLabel];
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-40);
    }];
    
    _selectButton = [GMButton buttonWithType:UIButtonTypeCustom];
    _selectButton.userInteractionEnabled = NO;
    [_selectButton setBackgroundImage:[UIImage imageNamed:@"post_normal"] forState:UIControlStateNormal];
    [_selectButton setBackgroundImage:[UIImage imageNamed:@"post_select"] forState:UIControlStateSelected];
    [self.contentView addSubview:_selectButton];
    [_selectButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.right.mas_equalTo(-15);
        make.width.height.mas_equalTo(16);
    }];
    [self.bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.mas_left).offset(15);
        make.right.mas_equalTo(self.mas_right).offset(-15);
        make.bottom.mas_equalTo(0);
        make.height.mas_equalTo(ONE_PIXEL);
    }];
}
- (void)setObject:(ALCreateTopicListObject *)object {
    _object = object;
    _nameLabel.text = object.name;
}
@end
