//
//  ALTopicDetailNavigationBar.m
//  GMAlpha
//
//  Created by zhb on 2018/11/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicDetailNavigationBar.h"

@interface ALTopicDetailNavigationBar ()
@property (nonatomic, strong) UIButton *backButton;
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UIButton *followButton;
@property (nonatomic, strong) UIButton *inviteButton;

@end

@implementation ALTopicDetailNavigationBar

#pragma mark - life cycle
- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.whiteColor;
    [self addSubview:self.backButton];
    [self addSubview:self.titleLabel];
    [self addSubview:self.followButton];
    [self addSubview:self.inviteButton];

}

- (void)updateConstraints {
    [self.backButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.left.bottom.equalTo(self);
        make.width.mas_equalTo(42);
    }];
    
    [self.inviteButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.right.equalTo(self).offset(-15);
    }];
    
    [self.followButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.right.equalTo(self.inviteButton.mas_left).offset(-20);
    }];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.left.equalTo(self.backButton.mas_right);
        make.right.equalTo(self.followButton.mas_left).offset(-50);
    }];
    
    [super updateConstraints];
}



#pragma mark - event
-(void)clickedBackButton {
    
}

- (void)clickedFollowButton:(UIButton *)sender {
    
}

- (void)clickedInviteButton:(UIButton *)sender {
    
}



#pragma mark - private methods

#pragma mark - getters and setters


- (UIButton *)backButton
{
    if (_backButton == nil) {
        _backButton = [[UIButton alloc] init];
        [_backButton setImage:[UIImage imageNamed:@"nav_ back"] forState:UIControlStateNormal];
        [_backButton addTarget:self action:@selector(clickedBackButton) forControlEvents:UIControlEventTouchUpInside];
    }
    return _backButton;
}


- (UILabel *)titleLabel
{
    if (_titleLabel == nil) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = UIColor.headlineText;
        _titleLabel.font = [UIFont gmLightFont:15];
        _titleLabel.numberOfLines = 0;
        _titleLabel.text = @"反对或附近酒店房间里分类进房间里累计发动机拉风的龙卷风多了几分垃圾分类进垃圾分类法拉风";
    }
    return _titleLabel;
}

- (UIButton *)followButton
{
    if (_followButton == nil) {
        _followButton = [[UIButton alloc] init];
        UIColor *color = [UIColor colorWithHexString:@"0093FF"];
        [_followButton setTitleColor:color forState:UIControlStateNormal];
        _followButton.titleLabel.font = [UIFont gmFont:16];
        [_followButton setTitle:@"关注" forState:UIControlStateNormal];
        [_followButton addTarget:self action:@selector(clickedFollowButton:) forControlEvents:UIControlEventTouchUpInside];
        [_followButton setContentHuggingPriority:300 forAxis:UILayoutConstraintAxisHorizontal];
        [_followButton setContentCompressionResistancePriority:800 forAxis:UILayoutConstraintAxisHorizontal];
        _followButton.backgroundColor = [UIColor redColor];

    }
    return _followButton;
}
- (UIButton *)inviteButton
{
    if (_inviteButton == nil) {
        _inviteButton = [[UIButton alloc] init];
        [_inviteButton setImage:[UIImage imageNamed:@"group_invite"] forState:UIControlStateNormal];
        UIColor *color = [UIColor colorWithHexString:@"0093FF"];
        [_inviteButton setTitleColor:color forState:UIControlStateNormal];
        _inviteButton.titleLabel.font = [UIFont gmFont:16];
        [_inviteButton setTitle:@"邀请" forState:UIControlStateNormal];
        [_inviteButton addTarget:self action:@selector(clickedInviteButton:) forControlEvents:UIControlEventTouchUpInside];
        [_inviteButton setContentHuggingPriority:300 forAxis:UILayoutConstraintAxisHorizontal];
        [_inviteButton setContentCompressionResistancePriority:800 forAxis:UILayoutConstraintAxisHorizontal];
        _inviteButton.backgroundColor = [UIColor redColor];
    }
    return _inviteButton;
}
@end
