//
//  ALTopicCommentObject.h
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//


// 用户Object
@interface ALTopicCommentUserObject : GMObject
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, strong) NSNumber *id;
@end

// 回复评论Object
@protocol ALTopicCommentUserObject @end
@interface ALTopicCommentReplyObject : GMObject
@property (nonatomic, copy) ALTopicCommentUserObject *reply_user;
@property (nonatomic, copy) ALTopicCommentUserObject *user;
@property (nonatomic, strong) NSNumber *id;
@property (nonatomic, copy) NSString *content;
@property (nonatomic, copy) NSString *translateContent;
@property (nonatomic, copy) NSString *timestamp;
@property (nonatomic, assign) BOOL translating;// 是否正在翻译
@property (nonatomic, assign) BOOL translate;// 是否已经翻译

@end

// 评论Object
@protocol ALTopicCommentReplyObject @end
@interface ALTopicCommentObject : GMObject

@property (nonatomic, strong) NSNumber *id;
@property (nonatomic, copy) NSString *date;
@property (nonatomic, strong) NSNumber *reply_id;
@property (nonatomic, copy) NSString *content;
@property (nonatomic, copy) NSString *translateContent;
@property (nonatomic, copy) NSString *create_time;
@property (nonatomic, copy) NSString *reply_num_str;
@property (nonatomic, copy) NSString *reply_num;
@property (nonatomic, strong) ALTopicCommentUserObject *user;
@property (nonatomic, strong) NSArray<ALTopicCommentReplyObject> *comments;
@property (nonatomic, assign) BOOL translating;// 是否正在翻译
@property (nonatomic, assign) BOOL translate;// 是否已经翻译

@end
