//
//  ALTopicCommentCell.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCommentCell.h"
#import "ALTranslateTool.h"
#import "ALPersonViewController.h"

@interface ALTopicCommentCell()
@property (nonatomic, strong) GMImageView *iconImageView;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *timeLabel;
@property (nonatomic, strong) GMButton *replyButton;
@property (nonatomic, strong) GMLabel *commentContentLabel;
@end
@implementation ALTopicCommentCell

- (void)setup {
    
    [super setup];
    
    self.bottomLine.hidden = YES;
    
    CGFloat iconImageViewWH = 35;
    // 头像
    GMImageView *iconImageView = [GMImageView new];
    iconImageView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
    iconImageView.layer.masksToBounds = YES;
    iconImageView.layer.cornerRadius = iconImageViewWH/2;
    iconImageView.userInteractionEnabled = YES;
    UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(gotoUserCenter)];
    [iconImageView addGestureRecognizer:tapGesture];
    [self.contentView addSubview:iconImageView];
    
    self.iconImageView = iconImageView;
    [_iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.width.height.mas_equalTo(iconImageViewWH);
        make.top.mas_equalTo(20);
    }];
    
    // 在线翻译
    GMButton *replyButton = [GMButton buttonWithTitle:@"在线翻译" backgroundColor:UIColor.clearColor titleFontSize:13 titleColor:RGBCOLOR_HEX(0x666666)];
    replyButton.titleLabel.font = [UIFont gmFont:13];
    [replyButton addTarget:self action:@selector(replyButtonClick) forControlEvents:UIControlEventTouchUpInside];
    replyButton.selected = NO;
    [self.contentView addSubview:replyButton];
    self.replyButton = replyButton;
    [_replyButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-15);
        make.height.mas_equalTo(20);
        make.width.mas_equalTo(55);
        make.top.mas_equalTo(_iconImageView.mas_top);
    }];
    
    // 名称
    GMLabel *nameLabel = [GMLabel new];
    nameLabel.text = @"";
    nameLabel.font = [UIFont gmBoldFont:13];
    nameLabel.textColor = UIColor.headlineText;
    [self.contentView addSubview:nameLabel];
    self.nameLabel = nameLabel;
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_iconImageView.mas_right).offset(8);
        make.right.mas_equalTo(_replyButton.mas_left).offset(-8);
        make.top.equalTo(_iconImageView).offset(4.5);
        make.height.mas_equalTo(13);
    }];
    
    // 时间
    GMLabel *timeLabel = [GMLabel new];
    timeLabel.text = @"";
    timeLabel.font = [UIFont gmFont:9];
    timeLabel.textColor = UIColor.auxiliaryTextLight;
    [self.contentView addSubview:timeLabel];
    self.timeLabel = timeLabel;
    [_timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.nameLabel);
        make.top.equalTo(self.nameLabel.mas_bottom).offset(4);
        make.height.mas_equalTo(9);
    }];
    
    // 内容
    GMLabel *commentContentLabel = [GMLabel new];
    commentContentLabel.text = @"";
    commentContentLabel.numberOfLines = 0;
    commentContentLabel.font = [UIFont gmFont:15];
    commentContentLabel.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 58 - 20;
    commentContentLabel.textColor = UIColor.headlineText;
    [self.contentView addSubview:commentContentLabel];
    self.commentContentLabel = commentContentLabel;
    [commentContentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_nameLabel);
        make.right.mas_equalTo(-25);
        make.top.equalTo(self.timeLabel.mas_bottom).offset(9);
        make.bottom.mas_equalTo(0);
    }];
}

- (void)setIsFirst:(BOOL)isFirst {
    _isFirst = isFirst;
    [_iconImageView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(isFirst ? 12 : 20);
    }];
}

- (void)setCommentObject:(ALTopicCommentObject *)commentObject {
    
    _commentObject = commentObject;
    [self.iconImageView setImageWithUrlString:commentObject.user.icon placeHolder:@"user_setter_default_icon_new"];
    self.nameLabel.text = commentObject.user.name;
    self.timeLabel.text = commentObject.create_time;
    self.commentContentLabel.text = commentObject.translate?commentObject.translateContent:commentObject.content;
}

- (void)replyButtonClick {
    
    self.replyButton.selected = !self.replyButton.isSelected;
    // 翻译按钮被点击了
    if (self.tralateClickBlock) {
        self.tralateClickBlock();
    }
    
    __weak __typeof(self)weakSelf = self;
    NSString *language =@"en";
    if ([[GMLoginManager shareInstance].user.language isNonEmpty]) {
        language = [GMLoginManager shareInstance].user.language;
    }
    // 翻译评论
    self.commentObject.translate = !self.commentObject.translate;
    if (![self.commentObject.translateContent isNonEmpty] && self.commentObject.translate) {
        [[ALTranslateTool shareInstance] transStr:self.commentObject.content toLanguage:language
                                     successBlock:^(NSString *resultString) {
                                         weakSelf.commentObject.translateContent = resultString;
                                         if (weakSelf.translateBlock && weakSelf.commentObject.translate) {
                                             weakSelf.translateBlock(weakSelf.commentObject, YES, 0);
                                         }
                                     } failBlock:^{
                                     }];
    } else {
        if (weakSelf.translateBlock) {
            weakSelf.translateBlock(weakSelf.commentObject, YES, 0);
        }
    }
    
    // 翻译回复
    for (int i = 0; i < self.commentObject.comments.count; i++) {
        ALTopicCommentReplyObject *replyObjectTemp = self.commentObject.comments[i];
        
        replyObjectTemp.translate = !replyObjectTemp.translate;
        if (![replyObjectTemp.translateContent isNonEmpty] && replyObjectTemp.translate) {
            
            [[ALTranslateTool shareInstance] transStr:replyObjectTemp.content toLanguage:language
                                         successBlock:^(NSString *resultString) {
                                             replyObjectTemp.translateContent = resultString;
                                             if (weakSelf.translateBlock && replyObjectTemp.translate) {
                                                 weakSelf.translateBlock(weakSelf.commentObject, NO, i);
                                             }
                                         } failBlock:^{
                                         }];
            } else {
                if (weakSelf.translateBlock) {
                    weakSelf.translateBlock(weakSelf.commentObject, NO, i);
                }
            }
    }
}

// 前往用户个人中心
- (void)gotoUserCenter {
    
    NSInteger userId = [SafeNumber(self.commentObject.user.id) integerValue];
    ALPersonViewController *toVc = [[ALPersonViewController alloc] initWithUserId:userId];
    [AppDelegate.navigation pushViewController:toVc animated:YES];
}

@end
