//
//  ALTopicCommentListView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCommentListView.h"

@interface ALTopicCommentListView()
@property (nonatomic, strong) ALTopicCommentListController *commentCrtl;
@property (nonatomic, strong) UIView *topicCommentView;
@property (nonatomic, copy) NSString *topicId;
@property (nonatomic, copy) NSString *fromPage;
@property (nonatomic, assign) WMCommentHandle commentHandle;
@end

@implementation ALTopicCommentListView

- (instancetype)initWithTopicId:(NSString *)topicId fromPage:(NSString *)fromPage commentHandle:(WMCommentHandle)commentHandle {
    if (self = [super initWithFrame:CGRectZero]) {
        
        self.topicId = topicId;
        self.fromPage = fromPage;
        self.commentHandle = commentHandle;
        
        [self setup];
        
        [self reloadCommentData];
    }
    return self;
}

- (void)setup {
    
    [super setup];
    self.animationType = GMPopupAnimationTypeFlipFromBottom;
    self.container.frame = CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - 53 - UIView.safeAreaInsetsBottom - 100);
    __weak __typeof(self)weakSelf = self;
    ALTopicCommentListController *commentCrtl = [[ALTopicCommentListController alloc] init];
    commentCrtl.viewModel.topicId = self.topicId;
    commentCrtl.fromPage = self.fromPage;
    commentCrtl.commentHandle = self.commentHandle;
    commentCrtl.didClickCloseBlock = ^{
        [weakSelf hide];
    };
    [self.container addSubview:commentCrtl.view];
    self.commentCrtl = commentCrtl;
    self.topicCommentView = commentCrtl.view;
    
    [self.topicCommentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.bottom.mas_equalTo(0);
    }];
    
    [self containerRectCorner];
}

- (void)reloadCommentData {
    [self.commentCrtl refreshList];
}

- (void)containerRectCorner {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:self.container.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(11, 11)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = self.container.bounds;
    maskLayer.path = maskPath.CGPath;
    self.container.layer.mask = maskLayer;
}

// 隐藏View
- (void)hide {
    
    [super hide];
    
    [Phobos track:@"comment_list_click_close" attributes:@{@"from": SafeString(self.fromPage),
                                                           @"busniess_id":SafeString(self.topicId)}];
}
@end
