//
//  ALTopicCommentTableView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCommentTableView.h"
#import "ALTopicReplyCell.h"
#import "ALTopicCommentCell.h"

@interface ALTopicCommentTableView()<UITableViewDataSource, UITableViewDelegate>

@end
@implementation ALTopicCommentTableView

-  (void)setup {
    [super setup];
    self.keyboardDismissMode = UIScrollViewKeyboardDismissModeNone;
    self.backgroundColor = UIColor.whiteColor;
    self.autoresizingMask = UIViewAutoresizingFlexibleHeight;
    self.dataSource = self;
    self.delegate = self;
    self.estimatedRowHeight = 0;
    self.rowHeight = 50;
    self.estimatedSectionFooterHeight = 0;
    self.estimatedSectionHeaderHeight = 0;
    [self registerCell:[ALTopicReplyCell class]];
    [self registerCell:[ALTopicCommentCell class]];
    
    if (@available(iOS 11.0, *)) {
        self.contentInsetAdjustmentBehavior = UIApplicationBackgroundFetchIntervalNever;
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 20;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    ALTopicReplyCell * cell = [tableView dequeueCell:[ALTopicCommentCell class] forIndexPath:indexPath];
    return cell;
}
@end
