//
//  ALTopicReplyCell.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicReplyCell.h"

@interface ALTopicReplyCell()
@property (nonatomic, strong) GMLabel *replyLabel;
@end

@implementation ALTopicReplyCell

- (void)setup {
    
    [super setup];
    
    self.bottomLine.hidden = YES;
    // 名称
    GMLabel *replyLabel = [GMLabel new];
    replyLabel.font = [UIFont gmBoldFont:13];
    replyLabel.numberOfLines = 0;
    replyLabel.textColor = UIColor.headlineText;
    replyLabel.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 58 - 20;
    [self.contentView addSubview:replyLabel];
    self.replyLabel = replyLabel;
    [_replyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(12);
        make.left.mas_equalTo(58);
        make.right.mas_equalTo(-20);
        make.height.mas_equalTo(13);
        make.bottom.mas_equalTo(0);
    }];
}

- (void)setReplyObject:(ALTopicCommentReplyObject *)replyObject {
    _replyObject = replyObject;
    NSString *content = replyObject.translate?replyObject.translateContent:replyObject.content;
    self.replyLabel.attributedText = [self replyAttributeString:replyObject.user.name
                                                     reply_user:replyObject.reply_user.name
                                                        content:content];
    
    CGFloat replyLabelH = [self.replyLabel.attributedText sizeForBoundingRectSize:CGSizeMake(MAINSCREEN_WIDTH - 58 - 20, MAXFLOAT)].height;
    [_replyLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(replyLabelH);
    }];

}

- (NSAttributedString *)replyAttributeString:(NSString *)user
                                  reply_user:(NSString *)reply_user
                                     content:(NSString *)content {
    
    if (reply_user && ![reply_user isEqualToString:@""]) {
        user = [NSString stringWithFormat:@"%@ ",user];
        reply_user = [NSString stringWithFormat:@" %@",reply_user];
    }
    NSAttributedString *userAttibute = [NSAttributedString string:user
                                                             font:[UIFont gmBoldFont:13]
                                                            color:UIColor.headlineText shadow:NO];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithAttributedString:userAttibute];
    
    if (reply_user && ![reply_user isEqualToString:@""]) {
        
        //Attachment
        NSTextAttachment *attachment = [[NSTextAttachment alloc] init];
        attachment.image = [UIImage imageNamed:@"topic_reply_target"];
        attachment.bounds = CGRectMake(0, 0, 5, 7);
        [attributedString appendAttributedString:[NSAttributedString attributedStringWithAttachment:attachment]];
        
        NSAttributedString *reply_userAttibute = [NSAttributedString string:reply_user
                                                                        font:[UIFont gmBoldFont:13]
                                                                       color:UIColor.headlineText shadow:NO];
        
        [attributedString appendAttributedString:reply_userAttibute];
    }
    
    [attributedString appendAttributedString:[NSAttributedString
                                              string:@": "
                                        font:[UIFont gmBoldFont:13]
                                       color:UIColor.headlineText shadow:NO]];
    
    [attributedString appendAttributedString:[NSAttributedString
                                              string:content
                                        font:[UIFont gmFont:13]
                                       color:UIColor.bodyText shadow:NO]];
    
    return attributedString;
}

@end
