//
//  WMPostInputView.h
//  ZhengXing
//
//  Created by wangyang on 3/9/15.
//  Copyright (c) 2015 Wanmei Creative. All rights reserved.
//

#define kPostInputViewH 50
@class WMPostInputView;
@protocol WMPostInputViewDelegate <NSObject>

- (void)inputViewWillCancel:(WMPostInputView *)inputView;
- (void)inputViewBeginEdit:(WMPostInputView *)inputView;
- (void)inputView:(WMPostInputView *)inputView sendText:(NSString *)text;
@end

/**
 *  @author wangyang, 16-04-27 16:04:10
 *
 *  可以在输入时自增高的replyView
 *  @since 5.9.4
 */
@interface WMPostInputView : GMView
@property (nonatomic, weak) id<WMPostInputViewDelegate> delegate;
@property (nonatomic, copy) NSString *placeHolder;
@property (nonatomic, copy) NSString *text;
@property (nonatomic, strong) UIImageView *iconImgeView;

- (void)show;
- (void)hide;
- (void)clear;

@end
