//
//  ALTopicCommentListViewModel.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCommentListViewModel.h"
#import "ALTopicCommentObject.h"

@implementation ALTopicCommentListViewModel

- (instancetype)init {
    if (self = [super init]) {
        _remoteUrl = API_TOPIC_COMMENTLIST;
    }
    return self;
}

- (void)buildParams{
    _params = @{@"topic_id":SafeNumber(self.topicId),
                @"page":@(self.page),
                @"count":@(self.count),
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic {
    
    NSDictionary *dicData = dic[@"data"];
    self.commentTotal = [dicData[@"reply_num_total"] integerValue];
    NSArray *dataArray = dicData[@"replies"];
    
    if (self.page == 1) {
        [self.dataArray removeAllObjects];
    }
    [self.dataArray addObjectsFromArray: [ALTopicCommentObject arrayOfModelsFromDictionaries:dataArray error:nil]];

}


/**
 执行创建评论请求

 @param successBlock
 @param failBlock
 */
- (void)excuteReplyTopic:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    
    [GMHudModule showLoading:nil];
    NSMutableDictionary *params = [[NSMutableDictionary alloc] initWithCapacity:0];
    [params setObject:self.topicId?:@"" forKey:@"topic_id"];
    if (self.replied_id && ![self.replied_id isEqualToString:@""]) {
        [params setObject:@([self.replied_id?:@"" intValue])  forKey:@"replied_id"];
    }
    [params setObject:self.content?:@"" forKey:@"content"];
    
    NSMutableURLRequest *request = [[GMNetworking customRequestWithApi:API_REPLY_CREATE
                                                                method:GMHTTPMethodPost
                                                            parameters:params] mutableCopy];
    [GMNetworking sendOC:request completion:^(GMResponseOC * _Nonnull response) {
        
        [GMHudModule hideLoading];
        
        if (response.isSuccess) {
            successBlock(response);
        } else {
            failBlock(response.message);
        }
    }];
}
@end
