//
//  ALTopicListVController.m
//  GMAlpha
//
//  Created by zhb on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicListVController.h"
#import "ALGroupDetailNavigationView.h"
#import "ALTopiDetailCardCell.h"
#import "ALGroupPostView.h"
#import "ALGroupInviteController.h"
#import "ALCreateTopicController.h"
#import "ALPersonViewController.h"
#import "Alpha-Swift.h"

#import "GMVideoObject.h"
#import "ALShareSheet.h"


@interface ALTopicListVController ()<ALTopiDetailCardCellDelegate>
/** 最底部 发帖View */
@property (nonatomic, strong) ALGroupPostView *bottomView;
@property (nonatomic, assign) NSInteger topicId;

@end

@implementation ALTopicListVController

@synthesize viewModel;

#pragma mark -- life cycle

- (instancetype)initWithTopicId:(NSInteger)topicId {
    self = [super init];
    if (self) {
        self.topicId = topicId;
        self.viewModel.topicId = topicId;
    }
    return self;
}

- (void)initController{
    [super initController];
    self.heightCacheByIndexPath = YES;
    self.viewModel = [[ALTopicDetailViewModel alloc] init];
    self.pageName = @"topic_detail";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = RGBCOLOR_HEX(0xF4F3F8);
    self.businessId = [NSString stringWithFormat:@"%zd", self.topicId];
    [self setupNav];
    [self setupObserver];
    [self setupSubviews];
}

- (void)setupNav {
    self.navigationBar.hidden = NO;
    self.navigationBar.title = @"详情";
}
- (void)setupObserver {
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(notificationActionUserLogin) name:LOGIN_SUCCESS_NOTIFICATION object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(notificationActionUserLogout) name:LOGOUT_NOTIFICATION object:nil];
}

- (void)setupSubviews {
    [self.view addSubview:self.bottomView];
    [self.bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
        make.height.mas_equalTo([self bottomHeight]);
    }];
    
    [self.table mas_updateConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-[self bottomHeight]);
    }];
    [self.table registerClass:[ALTopiDetailCardCell class] forCellReuseIdentifier:NSStringFromClass([ALTopiDetailCardCell class])];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context{
    [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
    self.bottomView.hidden = NO;
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

/** 通知 : 用户登录成功 */
- (void)notificationActionUserLogin {
    [self.viewModel handleHeaderRefreshing];
}

/** 通知 : 用户退出登录 */
- (void)notificationActionUserLogout {
    [self.viewModel handleHeaderRefreshing];
}

- (void)updateOtherUIData {
    [super updateOtherUIData];
    
    if (self.showComment != WMCommentHandleNoShow) {
        
        for (int i = 0; i < self.viewModel.dataArray.count; i++) {
            ALTopicCardObject *topicObj = self.viewModel.dataArray[i];
            
            if (self.topicId == topicObj.id) {
                
                NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:0];
                [self.table scrollToRowAtIndexPath:indexPath atScrollPosition:UITableViewScrollPositionNone animated:YES];
                
                [self showCommentHandle:self.showComment topicObj:topicObj];
                self.showComment = WMCommentHandleNoShow;
                break;
            }
        }
    }
}


- (void)backAction:(OCNavigationBarButton *)button
{
    if(self.isCreatContro == YES)
    {
        [self.navigationController popToRootViewControllerAnimated:YES];
    }
    else
    {
        [self.navigationController popViewControllerAnimated:YES];
    }
}

- (void)setIsCreatContro:(BOOL)isCreatContro
{
    _isCreatContro = isCreatContro;
    self.fd_interactivePopDisabled = isCreatContro;
}

#pragma mark -- system dataSource and delegate
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    //返回行数
    return self.viewModel.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString *reusableId = [self cellIdentifierAtIndexPath:indexPath];
    GMTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:reusableId forIndexPath:indexPath];
    cell.indexPath = indexPath;
    [self configDataForCell:cell atIndexPath:indexPath];
    [self configActionForCell:cell atIndexPath:indexPath];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    __weak __typeof(self)weakSelf = self;
    CGFloat height = [tableView fd_heightForCellWithIdentifier:[self cellIdentifierAtIndexPath:indexPath] cacheByIndexPath:indexPath configuration:^(id cell) {
        [weakSelf configDataForCell:cell atIndexPath:indexPath];
    }];
    return height;
}

- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 900;
}

#pragma mark - ALTopiDetailCardCellDelegate
/** delegate: 作者头像 */
- (void)cellLookAuthor:(ALTopiDetailCardCell *)cell {
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    ALPersonViewController *toVc = [[ALPersonViewController alloc] initWithUserId:topicObj.author.id];
    toVc.referer = self.pageName;
    [self pushViewController:toVc];
    //埋点:帖子卡片_点击_头像
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             };
    [Phobos track:@"topic_card_click_avatar" attributes:phDict];
}

/** delegatge: 关注<作者> */
- (void)cellDidFollowAuthor:(ALTopiDetailCardCell *)cell voteString:(NSString *)voteString
{
    //埋点: 关注<作者>
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             @"focus": voteString
                             };
    [Phobos track:@"topic_card_click_attention" attributes:phDict];
}

/** delegate : 埋点 展开followView */
- (void)cellShowFollowView:(ALTopiDetailCardCell *)cell {
    [self.table beginUpdates];
    [self.table reloadRowsAtIndexPaths:@[cell.indexPath] withRowAnimation:UITableViewRowAnimationNone];
    [self.table endUpdates];
    //埋点:
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             };
    [Phobos track:@"topic_card_click_attenunfold" attributes:phDict];
}

/** delegate: 关注了推荐列表里的人 */
- (void)cell:(ALTopiDetailCardCell *)cell followRecommedUse:(NSIndexPath *)indexPath voteString:(NSString *)voteString {
    
    //埋点:
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    ALTopicCardRecommentObject *obj = topicObj.recommendList[indexPath.row];
    NSInteger avatarId = obj.id;
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             @"avatar_id": SafeNumber(@(avatarId)),
                             @"focus": voteString
                             };
    [Phobos track:@"topic_card_recommend_click_focus" attributes:phDict];
    
}
/** delegate: 点击了推荐列表里的头像 */
- (void)cell:(ALTopiDetailCardCell *)cell selectedRecommedUseIcon:(NSIndexPath *)indexPath {
    //埋点:
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    ALTopicCardRecommentObject *obj = topicObj.recommendList[indexPath.row];
    NSInteger avatarId = obj.id;
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             @"avatar_id": SafeNumber(@(avatarId))
                             };
    [Phobos track:@"topic_card_recommend_click_avatar" attributes:phDict];
}


/** delegate : 展开文字 */
- (void)cellShowText:(ALTopiDetailCardCell *)cell {
    [self.table beginUpdates];
    [self.table reloadRowsAtIndexPaths:@[cell.indexPath] withRowAnimation:UITableViewRowAnimationNone];
    [self.table endUpdates];
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id))
                             };
    [Phobos track:@"topic_card_click_unfold" attributes:phDict];
}

/** delegate: 添加评论 */
- (void)cellDidAddReply:(ALTopiDetailCardCell *)cell
{
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    [self showCommentHandle:WMCommentHandleReply topicObj:topicObj];
}

/** delegate: 全部xx条评论 */
- (void)cellDidLookMore:(ALTopiDetailCardCell *)cell
{
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    [self showCommentHandle:WMCommentHandleLook topicObj:topicObj];
}

// 展示评论列表
- (void)showCommentHandle:(WMCommentHandle)commentHandle
                 topicObj:(ALTopicCardObject *)topicObj {
    
    ALTopicCommentListView *tempView = [[ALTopicCommentListView alloc] initWithTopicId:[NSString stringWithFormat:@"%ld", (long)(topicObj.id)] fromPage:self.pageName commentHandle:commentHandle];
    [self.view addSubview:tempView];
    
    NSString *evenName = @"";
    if (commentHandle == WMCommentHandleLook) {
        //埋点:全部**条评论
        evenName = @"topic_card_click_allcommentandexposed";
    } else if (commentHandle == WMCommentHandleReply) {
        //埋点:添加评论
        evenName = @"topic_card_click_writecomment";
    }
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             };
    [Phobos track:evenName attributes:phDict];
}

/** delegate: 💕点赞 */
- (void)cellDidVote:(ALTopiDetailCardCell *)cell voteString:(NSString *)voteString
{
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    //埋点:点赞
    NSDictionary *phDict = @{
                             @"page_name":  SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id)),
                             @"vote": voteString
                             };
    [Phobos track:@"topic_card_click_vote" attributes:phDict];

}

/** delegate: 分享 */
- (void)cellDidShare:(ALTopiDetailCardCell *)cell
{
    //1.分享数据组装
    ALTopicCardObject *topicObj = self.viewModel.dataArray[cell.indexPath.row];
    
    ALShareSheet *shareSheet = [[ALShareSheet alloc] init];
    [shareSheet show];
    shareSheet.shareTypeBlock = ^(GMSharePlatform platform) {
        
        NSString *title = @"";
        NSString *content = @"";
        NSString *image = topicObj.shareData.image;
        NSString *shareUrl = topicObj.shareData.url;
        shareUrl = [shareUrl stringByAppendingFormat:@"&channel=%@",[GMShareSDK shareChannel:platform]];
        NSString *user_id = [NSString stringWithFormat:@"%zd",[GMLoginManager shareInstance].user.userId];
        if (![GMLoginManager shareInstance].isVisitor) {
            shareUrl = [shareUrl stringByAppendingFormat:@"&from_user_id=%@",user_id];
        }
        
        switch (platform) {
            case GMSharePlatformWechatSession://微信好友
                title = topicObj.shareData.wechat.title;
                content = topicObj.shareData.wechat.content;
                break;
            case GMSharePlatformWechatTimeline://微信朋友圈
                title = topicObj.shareData.wechatline.title;
                content = topicObj.shareData.wechatline.content;
                break;
            case GMSharePlatformSinaWeibo://新浪微博
                title = topicObj.shareData.weibo.title;
                content = topicObj.shareData.weibo.content;
                break;
            case GMSharePlatformQQFriend:
                title = topicObj.shareData.qq.title;
                content = topicObj.shareData.qq.content;
                break;
            default:
                return;
        }
        
        NSMutableDictionary *mdict = [NSMutableDictionary dictionary];
        mdict[@"title"] = SafeString(title);
        mdict[@"content"] = SafeString(content);
        mdict[@"images"] = SafeString(image);
        mdict[@"url"] =  SafeString(shareUrl);
        [[GMShareSDK shareInstance] share:platform parameters:mdict onStateChanged:^(GMShareResponseState state, NSError *error) {
            if (state == GMShareResponseStateSuccess) {
                [GMHudModule toast:@"分享成功"];
            } else if(state == GMShareResponseStateCancel) {
                [GMHudModule toast:@"取消分享"];
            } else if(state == GMShareResponseStateFail) {
                [GMHudModule toast:@"分享失败"];
            }
        }];
    };
    //埋点:分享
    NSDictionary *phDict = @{
                             @"page_name":  SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id))
                             };
    [Phobos track:@"topic_card_click_share" attributes:phDict];
}

/** delegate: 删帖或举报 */
- (void)cellDidDelete:(ALTopiDetailCardCell *)cell
{
    //1,'登录权限控制'
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    
    //2,判断 操作用户是否是 组长 或 帖子作者
    ALTopicCardObject *obj = self.viewModel.dataArray[cell.indexPath.row];
    NSInteger userId = [GMLoginManager shareInstance].user.userId;
    NSInteger creatId = obj.author.id;
    NSInteger teamId = obj.groupCreatorId;
    //3.构建alert
    ALActionSheet *alertView = [[ALActionSheet alloc] init];
    if (userId == teamId || userId == creatId) {
        [alertView addItemWithTitle:@"删除" style:ALActionSheetItemTypeDefault color:UIColor.headlineText handle:^(NSInteger index) {
            [self requestDeleteTopic:cell.indexPath];
        }];
    } else {
        [alertView addItemWithTitle:@"举报" style:ALActionSheetItemTypeDefault color:UIColor.headlineText handle:^(NSInteger index) {
            [self requestComplainTopic:cell.indexPath];
        }];
    }
    [alertView addItemWithTitle:@"取消" style:ALActionSheetItemTypeCancel color:UIColor.headlineText handle:nil];
    [alertView show];
    //埋点:删帖或举报
    ALTopicCardObject *topicObj =  self.viewModel.dataArray[cell.indexPath.row];
    NSDictionary *phDict = @{
                             @"page_name":  SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id))
                             };
    [Phobos track:@"topic_card_click_more" attributes:phDict];

}

/** delegate: 在线翻译 */
- (void)cellDidTranslate:(ALTopiDetailCardCell *)cell
{
    [self.table beginUpdates];
    [self.table reloadRowsAtIndexPaths:@[cell.indexPath] withRowAnimation:UITableViewRowAnimationNone];
    [self.table endUpdates];  
    //埋点:在线翻译
    ALTopicCardObject *topicObj =  self.viewModel.dataArray[cell.indexPath.row];
    NSDictionary *phDict = @{
                             @"page_name":  SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId)),
                             @"topic_id": SafeNumber(@(topicObj.id))
                             };
    [Phobos track:@"topic_card_click_translate" attributes:phDict];
}

/** delegate: 播放视频 */
- (void)cell:(ALTopiDetailCardCell *)cell playVideo:(NSIndexPath *)indexPath inRect:(CGRect)rect {
    //获取video.url
    ALTopicCardObject *topicObj =  self.viewModel.dataArray[cell.indexPath.row];
    ALTopicCardImageObject *imgObj = topicObj.images[indexPath.row];
    GMVideoObject *videoObj = [self createVideoObjWithImageObject:imgObj];
    [self playVideo:videoObj animationStartRect:rect];
}

#pragma mark - event response
/** action : 底部发帖 */
- (void)clickPostView:(UITapGestureRecognizer *)tapGst
{
    //埋点:
    NSDictionary *phDict = @{
                             @"page_name": SafeString(self.pageName),
                             @"business_id": SafeNumber(@(self.topicId))
                             };
    [Phobos track:@"bottom_click_createtopic_btn" attributes:phDict];
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    ALCreateTopicController *toVc = [[ALCreateTopicController alloc] initWithComeInType:(FromWhereComeInCreat) from:@"topic_detail_click_create_topic"];
    toVc.referrerId = [NSString stringWithFormat:@"%ld",(long)self.viewModel.topicId];
    [self pushViewController:toVc];

}
#pragma mark - 网络
// API : 删除帖子
- (void)requestDeleteTopic:(NSIndexPath *)indexPath {
    NSObject *obj = self.viewModel.dataArray[indexPath.row];
    if (![obj isMemberOfClass:[ALTopicCardObject class]]) {
        return ;
    }
    ALTopicCardObject *topicObj = (ALTopicCardObject *)obj;
    NSInteger topicId = topicObj.id;
    
    NSDictionary *params = @{
                             @"topic_id": @(topicId)
                             };
    
    __weak typeof(self) weakSelf = self;
    [GMNetworking requestOCWithApi:API_V1_TOPIC_DELETE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        if (response.isSuccess == NO) return;
        if (response.data == nil) {return;}
        [weakSelf.viewModel.dataArray removeObject:topicObj];
        [weakSelf.table deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }];
}

// API : 举报帖子
- (void)requestComplainTopic:(NSIndexPath *)indexPath {
    NSObject *obj = self.viewModel.dataArray[indexPath.row];
    if (![obj isMemberOfClass:[ALTopicCardObject class]]) {
        return ;
    }
    ALTopicCardObject *topicObj = (ALTopicCardObject *)obj;
    NSInteger topicId = topicObj.id;
    
    NSDictionary *params = @{
                             @"comment_id": @(topicId)
                             };
    
    [GMNetworking requestOCWithApi:API_V1_TOPIC_COMPLAIN method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        if (response.isSuccess == NO) return;
        if (response.data == nil) {return;}
    }];
}


#pragma mark - private methods

- (NSString *)cellIdentifierAtIndexPath:(NSIndexPath *)indexPath {
    return NSStringFromClass([ALTopiDetailCardCell class]);
}

- (void)configDataForCell:(id)cell atIndexPath:(NSIndexPath *)indexPath {
    ALTopicCardObject *topicObj = self.viewModel.dataArray[indexPath.row];
    ALTopiDetailCardCell *topicCell = (ALTopiDetailCardCell *)cell;
    topicCell.topicObj = topicObj;
}

- (void)configActionForCell:(id)cell atIndexPath:(NSIndexPath *)indexPath {
    ALTopiDetailCardCell *topicCell = (ALTopiDetailCardCell *)cell;
    topicCell.delegate = self;
}

#pragma mark - getters and setters

- (ALGroupPostView *)bottomView {
    if (_bottomView == nil) {
        _bottomView = [[ALGroupPostView alloc] initWithImageName:@"group_post" placeholdString:@"我要发帖"];
        UITapGestureRecognizer *tapGst = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(clickPostView:)];
        tapGst.numberOfTapsRequired = 1;
        [_bottomView addGestureRecognizer:tapGst];
        _bottomView.hidden = YES;
    }
    return _bottomView;
}

- (GMVideoObject *)createVideoObjWithImageObject:(ALTopicCardImageObject *)imgObj {
    GMVideoObject *video = [[GMVideoObject alloc] init];
    video.topicId = @"";
    video.videoUrl = imgObj.videoUrl;
    video.videoPic = imgObj.imageUrl;
    video.cardType = @"topic";
    video.businessId = self.pageName;
    return video;
}

- (CGFloat)bottomHeight {
    return (self.bottomView.viewHeight + UIView.safeAreaInsetsBottom);
}

@end
