//
//  ALTopicCardFrameObject.m
//  GMAlpha
//
//  Created by zhb on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardFrameObject.h"
#import "NSAttributedString+Frame.h"

@interface ALTopicCardFrameObject ()
@property (nonatomic, strong) ALTopicCardObject *topicObj;

@property (nonatomic, assign) CGFloat authorH;
@property (nonatomic, assign) CGFloat followH;
@property (nonatomic, assign) CGFloat mediasH;
@property (nonatomic, assign) CGFloat descH;
@property (nonatomic, assign) CGFloat voteH;
@property (nonatomic, assign) CGFloat repliesH;
@property (nonatomic, assign) CGFloat bottomH;



@property (nonatomic, assign) CGFloat foldBtnY;
@property (nonatomic, assign) BOOL hiddenFoldBtn;
@property (nonatomic, assign) NSInteger descRows;


@end

@implementation ALTopicCardFrameObject
- (instancetype)initWithTopicCardObject:(ALTopicCardObject *)topicCardObj;
{
    self = [super init];
    if (self) {
        self.topicObj = topicCardObj;
        [self setup];
    }
    return self;
}

- (void)setup {
    self.authorH = 61;
    self.followH = 248;
    self.mediasH = [self descHFromString:_topicObj.content];
    
    
    
    
}

/** 获取mediaView的高度 */
- (CGFloat)mediasHFromTopicObj:(ALTopicCardObject *)topicObj {
    return (topicObj.images.count > 0) ? MAINSCREEN_WIDTH : 0;
}

/** 获取帖子正文的高度 */
- (CGFloat)descHFromString:(NSString *)content {
    CGFloat textMaxW = MAINSCREEN_WIDTH - 30.0;
    self.descRows = 0;
    if (content == nil || content.length <= 0){return 0;}
    UIFont *descFont = [UIFont gmFont:15];
    NSMutableAttributedString *contentAttrStr = [[NSMutableAttributedString alloc] initWithString:content attributes:@{NSFontAttributeName : descFont, NSForegroundColorAttributeName : UIColor.headlineText}];
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    [paragraphStyle setLineSpacing:0];
    [paragraphStyle setLineBreakMode:NSLineBreakByTruncatingTail];
    [contentAttrStr addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, contentAttrStr.length)];
    NSInteger rows = [contentAttrStr getLineCountWithMaxWidth:textMaxW];
    self.descRows = rows;
    if (rows <= 6) {
        self.hiddenFoldBtn = YES;
        self.foldBtnY = 0;
        CGRect textRect = [contentAttrStr getLastLineRectFromMaxWidth:textMaxW];
        return textRect.size.height;
    }
    self.hiddenFoldBtn = NO;
    CGRect textRect = [contentAttrStr getLineNumRectFromLineNum:6 isLastLine:NO maxWidth:textMaxW];
    CGFloat textH = textRect.size.height;
    self.foldBtnY = textH + 2;
    return (self.foldBtnY + 30);
}



@end
