//
//  ALTopicCardObject.h
//  GMAlpha
//
//  Created by zhb on 2018/11/23.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "WMShareObject.h"

// topics.replies.comments
@protocol ALTopicReplyCommentObject @end
@interface ALTopicReplyCommentObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *icon;
@end

// topic.replies.user
@protocol ALTopicReplyUserObject @end
@interface ALTopicReplyUserObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *icon;
@end



// topics.images
@protocol ALTopicCardImageObject @end
@interface ALTopicCardImageObject : GMObject
@property (nonatomic, copy) NSString *imageUrl;
@property (nonatomic, copy) NSString *videoUrl;
@property (nonatomic, assign) CGFloat width;
@property (nonatomic, assign) CGFloat height;
@end

// topics.author
@protocol ALTopicCardAuthorObject @end
@interface ALTopicCardAuthorObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, copy) NSString *address;
@property (nonatomic, copy) NSString *role;// 角色

@end

// topic.recommend_list
@protocol ALTopicCardRecommentObject @end
@interface ALTopicCardRecommentObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, copy) NSString *desc;
@property (nonatomic, assign) BOOL isFollow;
@property (nonatomic, assign) NSInteger type;
@end

// topics.replies
@protocol ALTopicCardReplieObject @end
@interface ALTopicCardReplieObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *content;
@property (nonatomic, assign) NSInteger repliedId;
@property (nonatomic, assign) NSInteger voteNum;
@property (nonatomic, assign) NSInteger topicId;
@property (nonatomic, assign) NSInteger replyNum;
@property (nonatomic, assign) NSInteger replyNumStr;
@property (nonatomic, assign) NSInteger createTime;
@property (nonatomic, strong) NSArray<ALTopicReplyCommentObject> *comments;
@property (nonatomic, strong) ALTopicReplyUserObject *user;
@end

// topics
@protocol ALTopicCardObject @end
@interface ALTopicCardObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *content;
@property (nonatomic, assign) NSInteger shareNum;
@property (nonatomic, assign) NSInteger voteNum;
@property (nonatomic, assign) NSInteger replyNum;
@property (nonatomic, copy) NSString *replyNumStr;
@property (nonatomic, copy) NSString *cover;
@property (nonatomic, assign) NSInteger createTime;
@property (nonatomic, copy) NSString *recommendListStr;
@property (nonatomic, assign) NSInteger groupCreatorId;
@property (nonatomic, strong) NSArray<ALTopicCardImageObject> *images;
@property (nonatomic, strong) WMShareObject *shareData;
@property (nonatomic, assign) BOOL isVideo;
@property (nonatomic, strong) ALTopicCardAuthorObject *author;
@property (nonatomic, strong) NSArray<ALTopicCardRecommentObject> *recommendList;
@property (nonatomic, assign) BOOL isFollow;
@property (nonatomic, assign) BOOL isVote;
@property (nonatomic, strong) NSArray<ALTopicCardReplieObject> *replies;

/** 是否展开 关注列表 横向*/
@property (nonatomic, assign) BOOL isShowFollowList;
@property (nonatomic, assign) CGFloat followHeight ;



/** 是否展开了帖子正文 */
@property (nonatomic, assign) NSInteger contentNumLines;
@property (nonatomic, assign) __block BOOL isTranslation;

@property (nonatomic, copy) NSString *sourceContent;
@property (nonatomic, copy) NSString *transContent;
@property (nonatomic, strong) NSMutableArray<NSString *> *transReplyArray;//最多3个
@property (nonatomic, strong) NSMutableArray<NSString *> *sourceReplyArray;//最多3个





//@property (nonatomic, assign) BOOL isSpreadOut;
//@property (nonatomic, strong) NSAttributedString *attrContent;
//@property (nonatomic, assign) BOOL isExculsionViewHidden;
//@property (nonatomic, assign) CGSize contentSize;
//@property (nonatomic, assign) CGSize allContentSize;
- (void)doOptimize;
@end


