//
//  ALTopiDetailCardCell.h
//  GMAlpha
//
//  Created by zhb on 2018/11/20.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupDetailObject.h"
#import "ALGroupDetailObject.h"
#import "ALTopicCardObject.h"

@class ALTopiDetailCardCell;
@protocol ALTopiDetailCardCellDelegate <NSObject>
/** delegate: 作者头像 */
- (void)cellLookAuthor:(ALTopiDetailCardCell *)cell;
/** delegate: 关注<作者> */
- (void)cellDidFollowAuthor:(ALTopiDetailCardCell *)cell voteString:(NSString *)voteString;
/** delegate : 埋点 展开followView */
- (void)cellShowFollowView:(ALTopiDetailCardCell *)cell;
/** delegate : 展开文字 */
- (void)cellShowText:(ALTopiDetailCardCell *)cell;
/** delegate: 添加评论 */
- (void)cellDidAddReply:(ALTopiDetailCardCell *)cell;
/** delegate: 💕点赞 */
- (void)cellDidVote:(ALTopiDetailCardCell *)cell voteString:(NSString *)voteString;
/** delegate: 分享 */
- (void)cellDidShare:(ALTopiDetailCardCell *)cell;
/** delegate: 删帖或举报 */
- (void)cellDidDelete:(ALTopiDetailCardCell *)cell;
/** delegate: 在线翻译 */
- (void)cellDidTranslate:(ALTopiDetailCardCell *)cell;
/** delegate: 全部xxx条评论 */
- (void)cellDidLookMore:(ALTopiDetailCardCell *)cell;
/** delegate: 播放视频 */
- (void)cell:(ALTopiDetailCardCell *)cell playVideo:(NSIndexPath *)indexPath inRect:(CGRect)rect;

/** delegate: 关注了推荐列表里的人 */
- (void)cell:(ALTopiDetailCardCell *)cell followRecommedUse:(NSIndexPath *)indexPath voteString:(NSString *)voteString;
/** delegate: 点击了推荐列表里的头像 */
- (void)cell:(ALTopiDetailCardCell *)cell selectedRecommedUseIcon:(NSIndexPath *)indexPath;
@end



/**
 帖子详情列表页,帖子cell
 */
@interface ALTopiDetailCardCell : GMTableViewCell
@property (nonatomic, weak) id<ALTopiDetailCardCellDelegate> delegate;
@property (nonatomic, strong) ALTopicCardObject *topicObj;
@end

