//
//  ALTopiDetailCardCell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/20.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopiDetailCardCell.h"
#import "ALGroupMedieView.h"
#import "ALRecommendUserView.h"
#import "Alpha-Swift.h"

#import "ALTopicCardObject.h"

#import "ALTopicCardAuthorView.h"
#import "ALTopicCardDescView.h"
#import "ALTopicCardVoteView.h"
#import "FDStackView.h"
#import "ALTopicCardBottomView.h"
#import "ALTranslateTool.h"
#import "ALShareSheet.h"

#import "GMVideoObject.h"
#import "NSAttributedString+Frame.h"


@interface ALTopiDetailCardCell() <ALGroupMedieViewDelegate, ALTopicCardDescViewDelegate, ALRecommendUserViewDelegate>

@property (nonatomic, strong) ALTopicCardAuthorView *authorView;
@property (nonatomic, strong) ALRecommendUserView *followView;
@property (nonatomic, strong) ALGroupMedieView *medieView;
@property (nonatomic, strong) ALTopicCardDescView *descView;
@property (nonatomic, strong) ALTopicCardVoteView *voteView;
@property (nonatomic, strong) ALTopicCardBottomView *bottomView;
@property (nonatomic, strong) UILabel *replyLabel;

@property (nonatomic, weak) UIView *lastView;
@property (nonatomic, assign) CGFloat descHeight;
@property (nonatomic, assign) CGFloat replyHeight;
@property (nonatomic, strong) MASConstraint *followHeightConstraint;
@property (nonatomic, strong) MASConstraint *medieHeightConstraint;

@end



@implementation ALTopiDetailCardCell

- (void)setTopicObj:(ALTopicCardObject *)topicObj {
    
    _topicObj = topicObj;
    //1.authorView
    self.authorView.topicObj = topicObj;
    
    //2.followView 高度待定.
    self.followHeightConstraint.mas_equalTo(topicObj.followHeight);
    self.followView.recommendUserArray = topicObj.recommendList;
    
    //3.medieView
    self.medieView.medieArray = topicObj.images;
    self.medieHeightConstraint.mas_equalTo((topicObj.images.count > 0) ? [ALGroupMedieView viewHeight] : 0);
    
    //4.descView.帖子文字内容
    self.descView.topicObj = topicObj;
    //    [self setDescViewData:topicObj];
    
    //5.voteView,添加评论/点赞/分享
    self.voteView.topicObj = topicObj;
    
    //6.stackView
//    [self setReplyLabelData:topicObj];
    self.replyLabel.attributedText = [ALTopiDetailCardCell getReplyAttrStringWithObj:topicObj];
    [self.replyLabel sizeToFit];
    
    //7.bottomView
    self.bottomView.topicObj = topicObj;

    //更新布局
    [self layoutIfNeeded];
//
}

#pragma mark - life cycle
- (void)setup {
    [super setup];
    [self addsubviewss];
    [self addLayoutss];
    
}
- (void)addsubviewss
{
    [self.contentView addSubview:self.authorView];
    [self.contentView addSubview:self.followView];
    [self.contentView addSubview:self.medieView];
    [self.contentView addSubview:self.descView];
    [self.contentView addSubview:self.voteView];// 添加评论View
    [self.contentView addSubview:self.replyLabel];
    [self.contentView addSubview:self.bottomView];
    self.bottomLine.backgroundColor = RGBCOLOR_HEX(0xF4F3F8);
    
    self.lastView = self.bottomView;
}

- (void)addLayoutss
{
    //1.authorView部分
    [self.authorView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.contentView).offset(0).priority(1000);
        make.left.right.equalTo(self.contentView).offset(0);
        make.width.mas_equalTo(MAINSCREEN_WIDTH);
        make.height.mas_equalTo([ALTopicCardAuthorView viewHeight]);
    }];
    
    //2.followAreaView-娇平
    [self.followView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.authorView.mas_bottom).offset(0).priority(1000);
        make.left.right.mas_offset(0);
        self.followHeightConstraint = make.height.mas_equalTo([ALRecommendUserView recommendUserViewHeight]);
    }];
    //3.medieView
    [self.medieView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.followView.mas_bottom).offset(0).priority(1000);
        make.left.right.mas_offset(0);
        self.medieHeightConstraint = make.height.mas_equalTo([ALGroupMedieView viewHeight]);
    }];
    //4.descView
    [self.descView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.medieView.mas_bottom).offset(0).priority(1000);
        make.left.right.mas_equalTo(0);
    }];
    //5.voteView
    [self.voteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.descView.mas_bottom).offset(0).priority(1000);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(30);
    }];
    //6.replyLabel
    [self.replyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.voteView.mas_bottom).offset(10);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.height.mas_greaterThanOrEqualTo(0);
    }];
    //7.bottomView
    [self.bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.replyLabel.mas_bottom);
        make.left.right.equalTo(self.contentView).offset(0);
        make.bottom.mas_equalTo(-11);
        make.height.mas_equalTo(40);
    }];
    
    [self.bottomLine mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(10);
    }];
}

- (void)updateLayouts
{
//    [self layoutIfNeeded];
}

- (void)reloadData {
    self.topicObj = self.topicObj;
//    [self layoutIfNeeded];
}

#pragma mark - 对外方法

#pragma mark - ALRecommendUserViewDelegate
/** delegate: 推荐列表,点击头像 */
- (void)recommendView:(ALRecommendUserView *)view clickedIconAtIndexPath:(NSIndexPath *)indexPath {
    if ([self.delegate respondsToSelector:@selector(cell:selectedRecommedUseIcon:)]) {
        [self.delegate cell:self selectedRecommedUseIcon:indexPath];
    }
}
/** delegate: 推荐列表,关注事件 */
- (void)recommendView:(ALRecommendUserView *)view clickedFollowAtIndexPath:(NSIndexPath *)indexPath voteString:(NSString *)voteString {
    if ([self.delegate respondsToSelector:@selector(cell:followRecommedUse:voteString:)]) {
        [self.delegate cell:self followRecommedUse:indexPath voteString:voteString];
    }
}

#pragma mark - ALGroupMedieViewDelegate
/** delegate: 播放视频 */
- (void)medieView:(ALGroupMedieView *)mediaView playVideoAtIndexPath:(NSIndexPath *)indexPath {    
    CGRect animationRect = [self.medieView convertRect:self.medieView.bounds toView:[AppDelegate shareInstance].window];
    if ([self.delegate respondsToSelector:@selector(cell:playVideo:inRect:)]) {
        [self.delegate cell:self playVideo:indexPath inRect:animationRect];
    }
}

#pragma mark - 事件
/** action: 作者头像 */
- (void)clickedAuthorIcon:(UIButton *)sender {
    // 作者头像
    if ([self.delegate respondsToSelector:@selector(cellLookAuthor:)]) {
        [self.delegate cellLookAuthor:self];
    }
}

/** action: 关注<作者> */
- (void)clickedFollowAuthor:(UIButton *)sender {
    //1.登录用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    //2.是否是自己
    NSInteger creatorId = self.topicObj.author.id;
    NSInteger userId = [GMLoginManager shareInstance].user.userId;
    if (creatorId == userId) {
        [AppDelegate.visibleController toast:@"您不能关注自己哦"];
        return;
    }
    //3.isFollow更改
    NSString *voteString = @"do";
    if (self.authorView.followButton.isSelected) {//已关注状态,只发送取消关注请求
        self.authorView.followButton.selected = NO;
        self.topicObj.isFollow = NO;
        [self requestCancelFollowAuthor];
        voteString = @"undo";
    }else {
        self.authorView.followButton.selected = YES;
        self.topicObj.isFollow = YES;
        [self requestAddFollowAuthor];
        voteString = @"do";
    }
    //2.高度更改
    if (self.topicObj.followHeight <= 0 && self.topicObj.isFollow) {
        self.topicObj.followHeight = [ALRecommendUserView recommendUserViewHeight];
        //3.更新布局
        [self reloadData];
        if ([self.delegate respondsToSelector:@selector(cellShowFollowView:)]) {
            [self.delegate cellShowFollowView:self];
        }
    }
    //4.关注了<作者>
    if ([self.delegate respondsToSelector:@selector(cellDidFollowAuthor:voteString:)]) {
        [self.delegate cellDidFollowAuthor:self voteString:voteString];
    }
}

/** action: 添加评论 */
-(void)clickedAddReply:(UITapGestureRecognizer *)tap {
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(cellDidAddReply:)]) {
        [self.delegate cellDidAddReply:self];
    }
}

/** action: 💕点赞 */
-(void)clickedVoteButton:(UIButton *)sender
{
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    NSString *voteString = @"do";
    if (sender.isSelected) {//取消关注
        [self requestCancelVote];
        self.topicObj.isVote = NO;
        self.topicObj.voteNum = (self.topicObj.voteNum - 1);
        self.voteView.topicObj = self.topicObj;
        voteString = @"undo";
    }else {//关注
        [self requestAddVote];
        self.topicObj.isVote = YES;
        self.topicObj.voteNum = (self.topicObj.voteNum + 1);
        self.voteView.topicObj = self.topicObj;
        voteString = @"do";
    }
    // TODO: 考虑是否还要代理.
    if ([self.delegate respondsToSelector:@selector(cellDidVote: voteString:)]) {
        [self.delegate cellDidVote:self voteString: voteString];
    }
}

/** action: 分享 */
- (void)clickedShareButton:(UIButton *)sender
{
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(cellDidShare:)]) {
        [self.delegate cellDidShare:self];
    }
}

/** action: 三点 */
- (void)clickedThreePointButton:(UIButton *)sender
{
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(cellDidDelete:)]) {
        [self.delegate cellDidDelete:self];
    }
}

/** action: 全部120条评论 */
- (void)clickedLookMoreButton:(UIButton *)sender
{
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    if ([self.delegate respondsToSelector:@selector(cellDidLookMore:)]) {
        [self.delegate cellDidLookMore:self];
    }
}

/** action: 在线翻译 */
- (void)clickedLookTranslateButton:(UIButton *)sender
{
    sender.userInteractionEnabled = NO;
    
    //展示原有数据
    if (self.topicObj.isTranslation) {
        sender.userInteractionEnabled = YES;
        self.topicObj.isTranslation = NO;
        self.topicObj.transContent = [self.topicObj.sourceContent mutableCopy];
        self.topicObj.transReplyArray = [self.topicObj.sourceReplyArray mutableCopy];
        //1.更改cell的数据
        [self reloadData];
        //2.外部更改高度
        if ([self.delegate respondsToSelector:@selector(cellDidTranslate:)]) {
            [self.delegate cellDidTranslate:self];
        }
        return;
    }
    NSString *toLanguage = @"en";
    NSString *userLanguage = [GMLoginManager shareInstance].user.language;
    if (userLanguage == nil || [userLanguage isEqualToString:@""]) {
        toLanguage = @"en";
    }else {
        toLanguage = userLanguage;
    }
    //进行翻译,展示翻译后的数据
    self.topicObj.isTranslation = YES;
    dispatch_queue_t queue = dispatch_queue_create("com.alpha", DISPATCH_QUEUE_CONCURRENT);
    
    NSMutableArray *sourceArray = [NSMutableArray array];
    [sourceArray addObject:[self.topicObj.content mutableCopy]] ;
    [sourceArray addObjectsFromArray:[self.topicObj.transReplyArray mutableCopy]];
    
    __block NSMutableArray *resultArray = [sourceArray mutableCopy];
    __weak typeof(self) weakSelf = self;
    __block NSInteger httpFinishCount = 0;
    
    dispatch_semaphore_t sem = dispatch_semaphore_create(0);
    dispatch_async(queue, ^{
        for (NSInteger i = 0; i < sourceArray.count; i++) {
            NSString *sourceString = sourceArray[i];
            [[ALTranslateTool shareInstance] transStr:sourceString toLanguage:toLanguage backBlock:^(NSString *resultString, NSError *error) {
                if (error == nil) {
                    [resultArray replaceObjectAtIndex:i withObject:resultString];
                }
                if (++httpFinishCount == sourceArray.count) {
                    dispatch_semaphore_signal(sem);
                }
            }];
        }
        //等待信号被释放..
        dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
        //最后,更改数据,刷新界面
        dispatch_async(dispatch_get_main_queue(), ^{
            //button可交互.
            sender.userInteractionEnabled = YES;
            if (resultArray.count != sourceArray.count) {
                return;
            }
            [weakSelf transReplyFinish:resultArray];
        });
    });
}

- (void)transReplyFinish:(NSMutableArray *)resultArray {
    for (NSInteger i = 0; i < resultArray.count; i++) {
        NSString *string = resultArray[i];
        if (i == 0) {
            self.topicObj.transContent = string;
        }else {
            self.topicObj.transReplyArray[i-1] = string;
        }
    }
    //1.更改cell的数据
    [self reloadData];
    //2.外部更改高度
    if ([self.delegate respondsToSelector:@selector(cellDidTranslate:)]) {
        [self.delegate cellDidTranslate:self];
    }
}

#pragma mark - ALTopicCardDescViewDelegate
- (void)descViewShowAllText:(ALTopicCardDescView *)descView {
    [self reloadData];
    if ([self.delegate respondsToSelector:@selector(cellShowText:)]) {
        [self.delegate cellShowText:self];
    }
}


#pragma mark - 网络
/** rq 关注<作者> */
- (void)requestAddFollowAuthor
{
    NSInteger creatorId = self.topicObj.author.id;
    NSDictionary *params = @{
                             @"type": @"1",
                             @"id": SafeNumber(@(creatorId))
                             };
    [GMNetworking requestOCWithApi:API_V1_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

/** rq 取消关注<作者> */
- (void)requestCancelFollowAuthor
{
    NSInteger creatorId = self.topicObj.author.id;
    NSDictionary *params = @{
                             @"type": @"1",
                             @"id": SafeNumber(@(creatorId))
                             };
    [GMNetworking requestOCWithApi:API_V1_CANCEL_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        if (response.data == nil) {return;}
    }];
}

/** rq 点赞帖子 */
- (void)requestAddVote
{
    NSDictionary *params = @{
                             @"type": @"0",
                             @"id": @(self.topicObj.id)
                             };
    
    [GMNetworking requestOCWithApi:API_V1_LIKE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

/** rq 取消点赞帖子 */
- (void)requestCancelVote
{
    
    NSDictionary *params = @{
                             @"type": @"0",
                             @"id": @(self.topicObj.id)
                             };
    
    [GMNetworking requestOCWithApi:API_V1_LIKE_CANCEL method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

#pragma mark - 私有方法
//- (void)setDescViewData:(ALTopicCardObject *)topicObj {
//    self.descView.topicObj = topicObj;
////    [self.descView sizeToFit];
////    self.descHeight = [ALTopicCardDescView descViewHeight:topicObj];
//}

//- (void)setReplyLabelData:(ALTopicCardObject *)topicObj {
//    self.replyLabel.attributedText = [ALTopiDetailCardCell getReplyAttrStringWithObj:topicObj];
//    [self.replyLabel sizeToFit];
////    self.replyHeight = [ALTopiDetailCardCell getReplyHeightWithObj:topicObj];
//}

#pragma mark - getter

- (ALTopicCardAuthorView *)authorView {
    if (_authorView == nil) {
        _authorView = [[ALTopicCardAuthorView alloc] init];
        _authorView.backgroundColor = UIColor.whiteColor;
        [_authorView.iconButton addTarget:self action:@selector(clickedAuthorIcon:) forControlEvents:UIControlEventTouchDown];
        [_authorView.followButton addTarget:self action:@selector(clickedFollowAuthor:) forControlEvents:UIControlEventTouchDown];
    }
    return _authorView;
}

- (ALRecommendUserView *)followView {
    if (_followView == nil) {
        _followView = [[ALRecommendUserView alloc] init];
        _followView.clipsToBounds = YES;
        _followView.delegate = self;
    }
    return _followView;
}

- (ALGroupMedieView *)medieView {
    if (_medieView == nil) {
        _medieView = [[ALGroupMedieView alloc] init];
        _medieView.backgroundColor = UIColor.whiteColor;
        _medieView.delegate = self;
    }
    return _medieView;
}

- (ALTopicCardDescView *)descView {
    if (_descView == nil) {
        _descView = [[ALTopicCardDescView alloc] init];
        _descView.delegate = self;
    }
    return _descView;
}

- (ALTopicCardVoteView *)voteView {
    if (_voteView == nil) {
        _voteView = [[ALTopicCardVoteView alloc] init];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedAddReply:)];
        [_voteView.grayView addGestureRecognizer:tap];
        [_voteView.voteButton addTarget:self action:@selector(clickedVoteButton:) forControlEvents:UIControlEventTouchUpInside];
        [_voteView.shareButton addTarget:self action:@selector(clickedShareButton:) forControlEvents:UIControlEventTouchDown];
        [_voteView.threePointButton addTarget:self action:@selector(clickedThreePointButton:) forControlEvents:UIControlEventTouchDown];

    }
    return _voteView;
}

- (ALTopicCardBottomView *)bottomView {
    if (_bottomView == nil) {
        _bottomView = [[ALTopicCardBottomView alloc] init];
        [_bottomView.lookMoreButton addTarget:self action:@selector(clickedLookMoreButton:) forControlEvents:UIControlEventTouchUpInside];
        [_bottomView.translateButton addTarget:self action:@selector(clickedLookTranslateButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _bottomView;
}

- (UILabel *)replyLabel {
    if (_replyLabel == nil) {
        _replyLabel = [[UILabel alloc] init];
        _replyLabel.textColor = UIColor.headlineText;
        _replyLabel.backgroundColor = UIColor.whiteColor;
        _replyLabel.textColor = UIColor.headlineText;
        _replyLabel.font = [UIFont gmFont:13];
        _replyLabel.numberOfLines = 0;
        [_replyLabel setContentHuggingPriority:1000 forAxis:0];
        [_replyLabel setContentHuggingPriority:1000 forAxis:1];
        [_replyLabel setContentCompressionResistancePriority:1000 forAxis:0];
        [_replyLabel setContentCompressionResistancePriority:1000 forAxis:1];
    }
    return _replyLabel;
}

+ (NSMutableAttributedString *)getReplyAttrStringWithObj:(ALTopicCardObject *)topicObj {
    NSMutableAttributedString *attrString = [[NSMutableAttributedString alloc] init];
    if (topicObj == nil || topicObj.transReplyArray == nil || topicObj.transReplyArray.count <= 0) {
        return attrString;
    }
    //1.获取attributedString
    NSInteger count = topicObj.transReplyArray.count;
    for (NSInteger i = 0; i < count; i++) {
        //1.获取userName
        ALTopicCardReplieObject *replyObj = topicObj.replies[i];
        NSString *userString = [NSString stringWithFormat:@"%@ : ", replyObj.user.name];
        if (i != 0) {
            userString = [NSString stringWithFormat:@"\n%@ : ", replyObj.user.name];
        }
        //2.获取评论内容
        NSString *replyString = topicObj.transReplyArray[i];
        //3.转变为attributedString
        NSDictionary *userAttrDict = @{NSFontAttributeName: [UIFont gmBoldFont:13], NSForegroundColorAttributeName: UIColor.headlineText};
        NSDictionary *replyAttrDict = @{NSFontAttributeName: [UIFont gmLightFont:13], NSForegroundColorAttributeName: UIColor.headlineText};
        
        NSAttributedString *userAttrString = [[NSAttributedString alloc] initWithString:userString attributes:userAttrDict];
        NSAttributedString *replyAttrString = [[NSAttributedString alloc] initWithString:replyString attributes:replyAttrDict];
        //4.拼接字符串
        [attrString appendAttributedString:userAttrString];
        [attrString appendAttributedString:replyAttrString];
    }
    //2.添加段落样式
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
    style.lineBreakMode = NSLineBreakByTruncatingTail;
    style.alignment = NSTextAlignmentLeft;
    style.lineSpacing = 2;
    [attrString addAttributes:@{NSParagraphStyleAttributeName : style} range:NSMakeRange(0, attrString.length)];
    
    return attrString;
}

+ (CGFloat)getReplyHeightWithObj:(ALTopicCardObject *)topicObj {
    NSAttributedString *attrString = [ALTopiDetailCardCell getReplyAttrStringWithObj:topicObj];
    if (attrString.length <= 0) {
        return 0;
    }
    UILabel *tempLabel = [[UILabel alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH - 30, MAXFLOAT)];
    tempLabel.attributedText = attrString;
    tempLabel.numberOfLines = 0;
    [tempLabel sizeToFit];
    CGSize size = tempLabel.frame.size;
    CGFloat height = ceil(size.height);
    return height;
}


@end

//
//- (void)setTopicObj:(ALTopicCardObject *)topicObj {
//
//    _topicObj = topicObj;
//    //1.authorView
//    NSString *icon = topicObj.author.icon;
//    UIImage *authorDefImg = [UIImage imageNamed:@"group_default_icon"];
//    NSURL *authorIcon = [NSURL URLWithString:icon];
//    [self.authorView.iconButton sd_setImageWithURL:authorIcon forState:UIControlStateNormal placeholderImage:authorDefImg];
//    self.authorView.nameLabel.text = topicObj.author.name;
//    self.authorView.addressLabel.text = topicObj.author.address;
//    self.authorView.followButton.selected = topicObj.isFollow;
//    if ([topicObj.author.role isNonEmpty]) {
//        [self.authorView.roleButton setTitle:topicObj.author.role forState:UIControlStateNormal];
//        self.authorView.roleButton.hidden = NO;
//    }else {
//        self.authorView.roleButton.hidden = YES;
//    }
//
//    //2.followView 高度待定.
//    self.followHeight = topicObj.followHeight;
//    self.followView.recommendUserArray = topicObj.recommendList;
//    //3.medieView
//    if (topicObj.images.count > 0) {
//        self.medieHeight = MAINSCREEN_WIDTH;
//        self.medieView.medieArray = topicObj.images;
//    }else {
//        self.medieHeight = 0;
//        self.medieView.medieArray = topicObj.images;
//    }
//    //4.descView.帖子文字内容
//    [self setDescViewData:topicObj];
//
//    //5.voteView,添加评论/点赞/分享
//    UIImage *defUserIcon = [UIImage imageNamed:@"user_setter_default_icon"];
//    NSURL *userUrl = [NSURL URLWithString:([GMLoginManager shareInstance].user.portrait)];
//    [self.voteView.iconView sd_setImageWithURL:userUrl placeholderImage:defUserIcon];
//    self.voteView.voteButton.selected = topicObj.isVote;
//    self.voteView.voteNumLabel.text = [self getVoteNumString];//内部做了隐藏处理
//    //6.stackView
//    [self setReplyLabelData:topicObj];
//
//    //7.bottomView
//    self.bottomView.topicObj = topicObj;
//
//    //更新布局
//    //    [self setNeedsUpdateConstraints];
//    [self updateLayouts];
//
//}

//- (NSString *)getVoteNumString {
//    NSString *result = @"赞";
//    NSInteger voteNum = self.topicObj.voteNum;
//    //策略
//    if (voteNum <= 0) {
//        self.voteView.voteNumLabel.hidden = YES;
//        return result;
//    }
//    self.voteView.voteNumLabel.hidden = NO;
//    if (voteNum <= 999) {
//        result = [NSString stringWithFormat:@"%ld", (long)voteNum];
//        return result;
//    }
//    if (voteNum <= 99999) {
//        result = [NSString stringWithFormat:@"%.1lfk", (voteNum * 1.0 / 1000.0)];
//        return result;
//    }
//
//    result = [NSString stringWithFormat:@"%.1lfw", (voteNum * 1.0 / 10000.0)];
//    return result;
//}
