//
//  ALTopicCardAuthorView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/22.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardAuthorView.h"


@interface ALTopicCardAuthorView ()
@property (nonatomic, strong) UIImage *defUserImage;
@property (nonatomic, strong) MASConstraint *nameLabelCentenY;
@end

@implementation ALTopicCardAuthorView

- (void)setTopicObj:(ALTopicCardObject *)topicObj {
    _topicObj = topicObj;
    //1.icon
    NSURL *authorIcon = [NSURL URLWithString:(topicObj.author.icon)];
    [self.iconButton sd_setImageWithURL:authorIcon forState:UIControlStateNormal placeholderImage:self.defUserImage];
    //2.name
    self.nameLabel.text = topicObj.author.name;
    //3.地址
    self.addressLabel.text = topicObj.author.address;
    if (topicObj.author.address == nil || topicObj.author.address.length <= 0) {
        self.addressLabel.hidden = YES;
        self.nameLabelCentenY.mas_offset(0);
    }else {
        self.addressLabel.hidden = NO;
        self.nameLabelCentenY.mas_offset(-9);
    }
    //4.关注
    self.followButton.selected = topicObj.isFollow;
    //5.role
    [self.roleButton setTitle:topicObj.author.role forState:UIControlStateNormal];
    if ([topicObj.author.role isNonEmpty]) {
        self.roleButton.hidden = NO;
    }else {
        self.roleButton.hidden = YES;
    }
}
+ (CGFloat)viewHeight {
    return 61.0;
}

#pragma mark - life cycle
- (void)setup
{
    [super setup];
    self.clipsToBounds = YES;
    [self addSubview:self.iconButton];
    [self addSubview:self.nameLabel];
    [self addSubview:self.addressLabel];
    [self addSubview:self.roleButton];
    [self addSubview:self.followButton];
    
    [self.iconButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(35, 35));
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        self.nameLabelCentenY = make.centerY.equalTo(self.iconButton).offset(-9);
        make.left.equalTo(self.iconButton.mas_right).offset(10);
    }];
    
    [self.addressLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.iconButton).offset(8);
        make.left.equalTo(self.nameLabel);
    }];
    
    [self.roleButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.nameLabel);
        make.left.equalTo(self.nameLabel.mas_right).offset(4);
        make.height.mas_equalTo(13);
    }];
    
    [self.followButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-19);
        make.top.bottom.mas_equalTo(0);
    }];
}

#pragma mark - getters and setters

- (UIButton *)iconButton {
    if (!_iconButton) {
        _iconButton = [[UIButton alloc] init];
        _iconButton.layer.cornerRadius = 17.5;
        _iconButton.layer.masksToBounds = YES;
        _iconButton.userInteractionEnabled = YES;
        [_iconButton sizeToFit];
    }
    return _iconButton;
}

- (UILabel *)nameLabel {
    if (_nameLabel == nil) {
        _nameLabel = [[UILabel alloc] init];
        _nameLabel.textColor = UIColor.headlineText;
        _nameLabel.font = [UIFont gmBoldFont:16];
    }
    return _nameLabel;
}

- (UILabel *)addressLabel {
    if (_addressLabel == nil) {
        _addressLabel = [[UILabel alloc] init];
        _addressLabel.textColor = UIColor.auxiliaryTextDark;
        _addressLabel.font = [UIFont gmFont:10];
    }
    return _addressLabel;
}

- (UIButton *)roleButton {
    if (!_roleButton) {
        _roleButton = [[UIButton alloc] init];
        [_roleButton setBackgroundImage:[UIImage imageNamed:@"author_role_bk"] forState:UIControlStateNormal];
        [_roleButton setBackgroundImage:[UIImage imageNamed:@"author_role_bk"] forState:UIControlStateSelected];
        [_roleButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        _roleButton.titleLabel.font = [UIFont gmBoldFont:9];
        [_roleButton sizeToFit];
    }
    return _roleButton;
}


- (UIButton *)followButton {
    if (_followButton == nil) {
        _followButton = [[UIButton alloc] init];
        [_followButton setImage:[UIImage imageNamed:@"author_follow"] forState:UIControlStateNormal];
        [_followButton setImage:[UIImage imageNamed:@"author_no_follow"] forState:UIControlStateSelected];
        [_followButton setContentHuggingPriority:300 forAxis:0];
        [_followButton setContentCompressionResistancePriority:800 forAxis:0];
    }
    return _followButton;
}

- (UIImage *)defUserImage {
    if (!_defUserImage) {
        _defUserImage = [UIImage imageNamed:@"user_setter_default_icon_new"];
    }
    return _defUserImage;
}

@end
