//
//  ALTopicCardBottomView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/22.
//  Copyright © 2018 Gengmei. All rights reserved.
//


#import "ALTopicCardBottomView.h"

@interface ALTopicCardBottomView ()
@property (nonatomic, strong) MASConstraint *transLeft;

@end

@implementation ALTopicCardBottomView
- (void)setTopicObj:(ALTopicCardObject *)topicObj {
    _topicObj = topicObj;
    [self.transLeft uninstall];

    if (topicObj.replyNumStr.length <= 0) {
        [self.lookMoreButton setTitle:@"" forState:UIControlStateNormal];
        self.lookMoreButton.hidden = YES;
        self.pointView.hidden = YES;
        self.translateButton.hidden = NO;
        
        [self bringSubviewToFront:self.translateButton];
        [self.translateButton mas_makeConstraints:^(MASConstraintMaker *make) {
            self.transLeft = make.left.equalTo(self.mas_left).offset(15);
        }];
    }
    else {
        NSString *string = topicObj.replyNumStr;
        [self.lookMoreButton setTitle:string forState:UIControlStateNormal];
        self.lookMoreButton.hidden = NO;
        self.pointView.hidden = NO;
        self.translateButton.hidden = NO;
        [self.translateButton mas_makeConstraints:^(MASConstraintMaker *make) {
            self.transLeft = make.left.equalTo(self.pointView.mas_right).offset(2);
        }];
    }
    [self layoutIfNeeded];
}


- (void)setup
{
    [super setup];
    self.clipsToBounds = YES;
    [self addSubview:self.lookMoreButton];
    [self addSubview:self.pointView];
    [self addSubview:self.translateButton];
    
    [self.lookMoreButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.bottom.mas_equalTo(0);
        make.centerY.mas_equalTo(0);
    }];
    [self.pointView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(2, 2));
        make.left.equalTo(self.lookMoreButton.mas_right).offset(2);
        make.centerY.mas_equalTo(0);
    }];
    [self.translateButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.centerY.mas_equalTo(0);
        self.transLeft = make.left.equalTo(self.pointView.mas_right).offset(2);
    }];
}



- (UIView *)pointView {
    if (_pointView == nil) {
        _pointView = [[UIView alloc] init];
        _pointView.backgroundColor = UIColor.blackColor;
        _pointView.layer.cornerRadius = 2 * 0.5;
        _pointView.clipsToBounds = YES;
    }
    return _pointView;
}
- (GMButton *)lookMoreButton {
    if (_lookMoreButton == nil) {
        _lookMoreButton = [[GMButton alloc] init];
        [_lookMoreButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateNormal];
        [_lookMoreButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateSelected];
        _lookMoreButton.titleLabel.font = [UIFont gmFont:13];
        _translateButton.enableAdaptive = YES;
    }
    return _lookMoreButton;
}

- (GMButton *)translateButton {
    if (_translateButton == nil) {
        _translateButton = [[GMButton alloc] init];
        [_translateButton setTitle:@"在线翻译" forState:UIControlStateNormal];
        [_translateButton setTitleColor:UIColor.headlineText forState:UIControlStateNormal];
        _translateButton.titleLabel.font = [UIFont gmFont:13];
        _translateButton.enableAdaptive = YES;
    }
    return _translateButton;
}



@end
