//
//  ALTopicCardDescView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/22.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardDescView.h"
#import "NSAttributedString+ZPAttributedString.h"

@interface ALTopicCardDescView ()
@property (nonatomic, strong) NSMutableDictionary *descAttrDict;
@property (nonatomic, strong) NSMutableDictionary *foldAttrDict;
@property (nonatomic, strong) ZPAttributedLabel *descLabel;
@property (nonatomic, strong) ZPAttributedLabel *foldLabel;

@property (nonatomic, strong) ZPTextLayout *descLayout;
@property (nonatomic, strong) NSAttributedString *foldAttrString;


@end

@implementation ALTopicCardDescView

#pragma mark - life cycle
- (void)setup
{
    [super setup];
    self.clipsToBounds = YES;
    [self addSubview:self.descLabel];
    [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(10);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.bottom.mas_equalTo(-10);
        make.height.mas_equalTo(0);
    }];
}

- (void)setTopicObj:(ALTopicCardObject *)topicObj {
    _topicObj = topicObj;
    NSString *descString = topicObj.transContent;
    NSMutableAttributedString *descAttrString = [[NSMutableAttributedString alloc] initWithString:descString attributes:self.descAttrDict];
    //1.Label
    self.descLabel.attributedText = descAttrString;
    
    //2.layout
    [self.descLayout setupContainerSize:CGSizeMake(MAINSCREEN_WIDTH-30, MAXFLOAT) text:descAttrString];
    self.descLayout.numberOfLines = topicObj.contentNumLines;
    self.descLayout.truncationText = self.foldAttrString;
    
    //3.闭合
    self.descLabel.layout = self.descLayout;
    CGFloat height = self.descLayout.textBoundSize.height;
    [self.descLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(height);
    }];
    [self layoutIfNeeded];
}

+ (CGFloat)descViewHeight:(ALTopicCardObject *)topicObj {
    CGFloat resultH = 0;
    NSString *descString = topicObj.transContent;
    NSDictionary *descAttrDict = [ALTopicCardDescView attributeWithFont:[UIFont gmFont:15] andTextColor:UIColor.headlineText lineBreakMode:NSLineBreakByCharWrapping lineSpacing:3];
    NSMutableAttributedString *descAttrString = [[NSMutableAttributedString alloc] initWithString:descString attributes:descAttrDict];
    NSDictionary *foldAttrDict = [ALTopicCardDescView attributeWithFont:[UIFont gmFont:15] andTextColor:[UIColor auxiliaryTextLight] lineBreakMode:NSLineBreakByCharWrapping lineSpacing:3];
    NSMutableAttributedString *foldAttrString = [[NSMutableAttributedString alloc] initWithString:@"\u2026展开" attributes:foldAttrDict];
    ZPAttributedLabel *foldLb = [ZPAttributedLabel new];
    foldLb.attributedText = foldAttrString;
    [foldLb sizeToFit];

    
    NSAttributedString *truncationText = [NSAttributedString zp_attachmentWithContent:foldLb contentMode:UIViewContentModeCenter attachmentSize:foldLb.bounds.size alignToFont:[UIFont gmFont:15] alignment:ZPTextVerticalAlignmentCenter];

    ZPTextLayout *layout = [ZPTextLayout layoutWithContainerSize:CGSizeMake(MAINSCREEN_WIDTH-30, MAXFLOAT) text:descAttrString];
    layout.numberOfLines = topicObj.contentNumLines;
    layout.truncationText = truncationText;
    CGFloat height = layout.textBoundSize.height;
    if (height > 0) {
        resultH = height + 20;
    }
    return resultH;
}

#pragma mark - getter && setter

- (void)cleckedUnfold:(UITapGestureRecognizer *)tap {
    self.topicObj.contentNumLines = 0;
    if ([self.delegate respondsToSelector:@selector(descViewShowAllText:)]) {
        [self.delegate descViewShowAllText:self];
    }
}


- (ZPAttributedLabel *)descLabel {
    if (!_descLabel) {
        _descLabel = [[ZPAttributedLabel alloc] initWithFrame:(CGRect){0, 0, 0, 0}];
        _descLabel.font = [UIFont gmFont:14];
        _descLabel.textColor = [UIColor redColor];
        _descLabel.lineBreakMode = NSLineBreakByWordWrapping;
    }
    return _descLabel;
}

- (ZPAttributedLabel *)foldLabel {
    if (!_foldLabel) {
        NSMutableAttributedString *moreText = [[NSMutableAttributedString alloc] initWithString:@"\u2026展开" attributes:self.foldAttrDict];
        _foldLabel = [[ZPAttributedLabel alloc] init];
        _foldLabel.attributedText = moreText;
        [_foldLabel sizeToFit];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(cleckedUnfold:)];
        [_foldLabel addGestureRecognizer:tap];
    }
    return _foldLabel;
}

- (ZPTextLayout *)descLayout {
    if (!_descLayout) {
        _descLayout = [[ZPTextLayout alloc] init];
        _descLayout.truncationText = self.foldAttrString;
    }
    return _descLayout;
}


- (NSMutableDictionary *)descAttrDict {
    if (!_descAttrDict) {
        _descAttrDict = [ALTopicCardDescView attributeWithFont:[UIFont gmFont:15] andTextColor:UIColor.headlineText lineBreakMode:NSLineBreakByCharWrapping lineSpacing:3];
    }
    return _descAttrDict;
}

- (NSMutableDictionary *)foldAttrDict {
    if (!_foldAttrDict) {
        _foldAttrDict = [ALTopicCardDescView attributeWithFont:[UIFont gmFont:15] andTextColor:[UIColor auxiliaryTextLight] lineBreakMode:NSLineBreakByCharWrapping lineSpacing:3];
    }
    return _foldAttrDict;
}

- (NSAttributedString *)foldAttrString {
    return [NSAttributedString zp_attachmentWithContent:self.foldLabel contentMode:UIViewContentModeCenter attachmentSize:self.foldLabel.bounds.size alignToFont:[UIFont gmFont:15] alignment:ZPTextVerticalAlignmentCenter];
}

+ (NSMutableDictionary *)attributeWithFont:(UIFont *)font andTextColor:(UIColor *)color lineBreakMode:(NSLineBreakMode)lineBreakMode lineSpacing:(CGFloat)lineSpacing
{
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    [paragraphStyle setLineBreakMode:lineBreakMode];
    [paragraphStyle setAlignment:NSTextAlignmentLeft];
    [paragraphStyle setLineSpacing:lineSpacing];
    NSDictionary *dictionary = @{NSFontAttributeName: font, NSForegroundColorAttributeName: color, NSParagraphStyleAttributeName: paragraphStyle};
    return [NSMutableDictionary dictionaryWithDictionary:dictionary];
}


@end













//- (UILabel *)descLabel
//{
//    if (_descLabel == nil) {
//        _descLabel = [[UILabel alloc] init];
//        _descLabel.textColor = UIColor.headlineText;
//        _descLabel.font = [UIFont gmFont:15];
//        _descLabel.numberOfLines = 0;
//        _descLabel.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 30;
//        _descLabel.text = @"鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前,鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前";
//        [_descLabel setContentHuggingPriority:1000 forAxis:0];
//        [_descLabel setContentHuggingPriority:1000 forAxis:1];
//        [_descLabel setContentCompressionResistancePriority:1000 forAxis:0];
//        [_descLabel setContentCompressionResistancePriority:1000 forAxis:1];
//
//    }
//    return _descLabel;
//}


//- (UIButton *)foldButton
//{
//    if (_foldButton == nil) {
//        _foldButton = [[UIButton alloc] init];
//        _foldButton = [[UIButton alloc] init];
//        [_foldButton setTitleColor:UIColor.redColor forState:UIControlStateNormal];
//        [_foldButton setTitleColor:UIColor.redColor forState:UIControlStateSelected];
//        _foldButton.titleLabel.font = [UIFont gmFont:13];
//        [_foldButton setTitle:@"[展开]" forState:UIControlStateNormal];
//        [_foldButton setTitle:@"[收起]" forState:UIControlStateSelected];
//        [_foldButton setContentHuggingPriority:1000 forAxis:0];
//        [_foldButton setContentHuggingPriority:1000 forAxis:1];
//        [_foldButton setContentCompressionResistancePriority:1000 forAxis:0];
//        [_foldButton setContentCompressionResistancePriority:1000 forAxis:1];
//    }
//    return _foldButton;
//}
