
//
//  ALTopicCardVoteView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/22.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardVoteView.h"

@interface ALTopicCardVoteView ()
@property (nonatomic, strong) UILabel *addReplyLabel;

@end


@implementation ALTopicCardVoteView

+ (CGFloat)viewHeight {
    return 30;
}

- (void)setTopicObj:(ALTopicCardObject *)topicObj {
    _topicObj = topicObj;
    UIImage *defUserIcon = [UIImage imageNamed:@"user_setter_default_icon"];
    NSURL *userUrl = [NSURL URLWithString:([GMLoginManager shareInstance].user.portrait)];
    [self.iconView sd_setImageWithURL:userUrl placeholderImage:defUserIcon];
    self.voteButton.selected = topicObj.isVote;
    self.voteNumLabel.text = [self getVoteNumString];//内部做了隐藏处理
    self.voteNumLabel.text = @"999";
}


- (void)setup
{
    [super setup];
    self.clipsToBounds = YES;
    [self addSubview:self.grayView];
    [self addSubview:self.iconView];
    [self addSubview:self.addReplyLabel];
    [self addSubview:self.voteButton];
    [self addSubview:self.shareButton];
    [self addSubview:self.threePointButton];
    [self addSubview:self.voteNumLabel];
    
    [self addLayouts];
}

- (void)addLayouts
{
    [self.grayView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(1);
        make.bottom.mas_equalTo(-1);
        make.height.mas_equalTo(28);
    }];
    [self.iconView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.grayView.mas_left).offset(5);
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.centerY.mas_equalTo(0);
    }];
    
    [self.addReplyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.iconView.mas_right).offset(5);
        make.centerY.mas_equalTo(0);
        make.right.equalTo(self.grayView);
    }];
    
    [self.voteButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.grayView.mas_right).offset(25);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.shareButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.voteButton.mas_right).offset(20);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.threePointButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.shareButton.mas_right).offset(20);
        make.right.mas_equalTo(-15);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.voteNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.voteButton.mas_centerX).offset(3);
        make.right.lessThanOrEqualTo(self.shareButton.mas_left);
        make.bottom.equalTo(self.voteButton.mas_centerY).offset(-2);
    }];
}



- (UIView *)grayView {
    if (_grayView == nil) {
        _grayView = [[UIView alloc] init];
        _grayView.backgroundColor = UIColor.background;
        _grayView.layer.cornerRadius = 14;
        _grayView.layer.masksToBounds = YES;
    }
    return _grayView;
}

- (UILabel *)addReplyLabel {
    if (_addReplyLabel == nil) {
        _addReplyLabel = [[UILabel alloc] init];
        _addReplyLabel.textColor = UIColor.auxiliaryTextLight;
        _addReplyLabel.text = @"添加评论";
        _addReplyLabel.font = [UIFont gmFont:13];
    }
    return _addReplyLabel;
}

- (UIImageView *)iconView {
    if (_iconView == nil) {
        _iconView = [[UIImageView alloc] init];
        _iconView.image = [UIImage imageNamed:@"group_post"];
        _iconView.layer.cornerRadius = 10;
        _iconView.layer.masksToBounds = YES;
    }
    return _iconView;
}

- (UIButton *)voteButton {
    if (_voteButton == nil) {
        _voteButton = [[UIButton alloc] init];
        [_voteButton setImage:[UIImage imageNamed:@"group_no_vote"] forState:UIControlStateNormal];
        [_voteButton setImage:[UIImage imageNamed:@"group_vote"] forState:UIControlStateSelected];
        [_voteButton sizeToFit];
    }
    return _voteButton;
}

- (UIButton *)shareButton {
    if (_shareButton == nil) {
        _shareButton = [[UIButton alloc] init];
        [_shareButton setImage:[UIImage imageNamed:@"group_share"] forState:UIControlStateNormal];
        [_shareButton sizeToFit];
    }
    return _shareButton;
}
- (UIButton *)threePointButton {
    if (_threePointButton == nil) {
        _threePointButton = [[UIButton alloc] init];
        [_threePointButton setImage:[UIImage imageNamed:@"group_three_point"] forState:UIControlStateNormal];
        [_threePointButton sizeToFit];
    }
    return _threePointButton;
}

- (GMLabel *)voteNumLabel {
    if (_voteNumLabel == nil) {
        _voteNumLabel = [[GMLabel alloc] init];
        _voteNumLabel.textColor = UIColor.headlineText;
        _voteNumLabel.backgroundColor = [UIColor whiteColor];
        _voteNumLabel.font = [UIFont gmFont:10];
        _voteNumLabel.paddingEdge = UIEdgeInsetsMake(0, 4, 0, 0);
        _voteNumLabel.textAlignment = NSTextAlignmentCenter;
        _voteNumLabel.layer.cornerRadius = 5;
        _voteNumLabel.layer.masksToBounds = YES;
    }
    return _voteNumLabel;
}

- (NSString *)getVoteNumString {
    NSString *result = @"赞";
    NSInteger voteNum = self.topicObj.voteNum;
    //策略
    if (voteNum <= 0) {
        self.voteNumLabel.hidden = YES;
        return result;
    }
    self.voteNumLabel.hidden = NO;
    if (voteNum <= 999) {
        result = [NSString stringWithFormat:@"%ld", (long)voteNum];
        return result;
    }
    if (voteNum <= 99999) {
        result = [NSString stringWithFormat:@"%.1lfk", (voteNum * 1.0 / 1000.0)];
        return result;
    }
    
    result = [NSString stringWithFormat:@"%.1lfw", (voteNum * 1.0 / 10000.0)];
    return result;
}
@end
