//
//  ALTopicDetailViewModel.m
//  GMAlpha
//
//  Created by zhb on 2018/11/14.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicDetailViewModel.h"

@implementation ALTopicDetailViewModel
- (instancetype)init
{
    self = [super init];
    if (self) {
        _remoteUrl = API_V1_TOPIC_DETAIL;
        _deduplicationKey = @"id";
    }
    return self;
}

- (void)buildParams{
    _params = @{
                @"topic_id":SafeNumber(@(self.topicId)),
                @"type": @(1),
                @"page":@(self.page),
                @"count":@(10)
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *contentData = dic[@"data"];
    NSArray *topics = contentData[@"topics"];
    if ([topics isKindOfClass:[NSNull class]]) {
        return;
    }

    [self deduplicationForArray:topics buildModelBlock:^id(NSDictionary *dic) {
        ALTopicCardObject *obj = [[ALTopicCardObject alloc] initWithDictionary:dic error:nil];
        [obj doOptimize];
        return obj;
    }];
}




@end
