//
//  ALTransController.h
//  GMAlpha
//
//  Created by Q14 on 2018/11/27.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <UIKit/UIKit.h>

#include "Filter/FilterCell.h"
#include "Filter/FilterUICollectionView.h"

NS_ASSUME_NONNULL_BEGIN
@interface ALIndexFilter : FilterUICollectionView
@property(nonatomic,strong) NSArray<NSString *> *indexSource;
@property(nonatomic,assign) int selectedIndex;
- (NSString *) getSource:(int) index;
@end
//////////////////////////////////////////////////////////////////////////////
@interface ALFilterView : FilterUICollectionView
@property(nonatomic,assign) int selectedIndex;
- (int) getCurrentSelectedIndex;
- (NSString *) getSource:(int) index;
- (NSString *) getSource:(int)page andIndex:(int)index;
//////////////////////////////////
@property(nonatomic,strong) NSArray<NSString *> *noseSource;
@property(nonatomic,strong) NSArray<NSString *> *noseIcon;
@property(nonatomic,strong) NSArray<NSString *> *eyeSource;
@property(nonatomic,strong) NSArray<NSString *> *eyeIcon;
@property(nonatomic,strong) NSArray<NSString *> *mouthSource;
@property(nonatomic,strong) NSArray<NSString *> *mouthIcon;
@property(nonatomic,strong) NSArray<NSString *> *faceSource;
@property(nonatomic,strong) NSArray<NSString *> *faceIcon;
@property(nonatomic,strong) NSArray<NSString *> *beautySource;
@property(nonatomic,strong) NSArray<NSString *> *beautyIcon;
@end

@interface ALTransController : UIViewController
@property(nonatomic,strong) ALIndexFilter *indexfilterView;
- (void) selectIndex:(int) index;
//////////
@property(nonatomic,strong) ALFilterView * filterView;
- (void) selectFilter:(int) index;
@end

NS_ASSUME_NONNULL_END
