//
//  ALTransController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/27.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTransController.h"
#include "SliderPanel.h"
#include "Utils/UILabelUtils.h"
#include "Utils/UIButtonUtils.h"
#include "LogView.h"
#include "OBJView.h"
#include "Utils/FileUtils.h"
#include "SDKHelper.h"
/////////////////////////////////////
//必须从 0 开始，连续性
static const int INDEX_NOSE  = 0;
static const int INDEX_EYE   = 1;
static const int INDEX_MOUTH = 2;
static const int INDEX_FACE  = 3;
static const int INDEX_BEAUTY = 4;
/////////////////////////////////////////////////////////////
@interface ALIndexFilter()
@property(nonatomic,strong) ALTransController * viewController;
@end

@implementation ALIndexFilter

- (NSString *) getSource:(int) index
{
    return [self.indexSource objectAtIndex:index];
}

- (void)setIndexSource:(NSArray<NSString *> *)indexSource
{
    _indexSource = indexSource;
    [self reload];
}

- (void)setSelectedIndex:(int)selectedIndex
{
    if(_selectedIndex != selectedIndex){
        _selectedIndex = selectedIndex;
        [self.viewController selectIndex:_selectedIndex];
    }
}
////////////////////////////////////////////////
-(CGSize) createItemSize
{
    return CGSizeMake(100, 20.0);
}

- (void) buildIndexFilter:(ALTransController*)controller
{
    self.viewController = controller;
    NSMutableArray * array = [NSMutableArray new];
    [array insertObject:@"鼻子形变" atIndex:INDEX_NOSE];
    [array insertObject:@"眼部形变" atIndex:INDEX_EYE];
    [array insertObject:@"嘴部形变" atIndex:INDEX_MOUTH];
    [array insertObject:@"脸颊形变" atIndex:INDEX_FACE];
    [array insertObject:@"美白变化" atIndex:INDEX_BEAUTY];
    self.indexSource = array;
}

- (void) didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    //NSLog(@"didSelectItemAtIndexPath");
    self.selectedIndex = (int) indexPath.row;
}

- (UICollectionViewCell*) createOrUpdateUICollectionViewCell:(UICollectionViewCell *)cell cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    UILabel * title = [cell.contentView viewWithTag:100];
    //NSLog(@"cellForItemAtIndexPath :%@", title);
    if(title == nil){
        title = [self createCell:cell.contentView.frame];
        title.tag = 100;
        [cell.contentView addSubview:title];
    }
    title.text = self.indexSource[indexPath.row];
    return [super createOrUpdateUICollectionViewCell:cell cellForItemAtIndexPath:indexPath];
}

- (UILabel *) createCell:(CGRect) rect
{
    UILabel * lab = [UILabelUtils createUILabelWithFrame:CGRectMake(0, 0, rect.size.width, rect.size.height)];
    return lab;
}

- (NSInteger) numberOfItemsInSection:(NSInteger)section
{
    if(!_indexSource){
        return 0;
    }
    return _indexSource.count;
}
@end
///////////////////////////////////////////////////////////////////////////////////////
@interface ALFilterView()
@property(nonatomic,strong) ALTransController * viewController;
@end

@implementation ALFilterView

- (void)setSelectedIndex:(int)selectedIndex
{
    _selectedIndex = selectedIndex;
    [self.viewController selectFilter:_selectedIndex];
}

- (void) buildIndexFilter:(ALTransController*)controller
{
    self.viewController = controller;
    [self buildSourceAndIcon];
    [self reload];
}

- (void)reload
{
    NSCAssert(_noseIcon.count == _noseSource.count, @"鼻子配置错误");
    NSCAssert(_eyeIcon.count == _eyeSource.count, @"眼部配置错误");
    NSCAssert(_mouthIcon.count == _mouthSource.count, @"嘴部配置错误");
    NSCAssert(_faceIcon.count == _faceSource.count, @"脸颊配置错误");
    NSCAssert(_beautyIcon.count == _beautySource.count, @"美白配置错误");
    [super reload];
}
//@[@"brightness", @"contrast", @"saturation", @"temp", @"hightlight", @"shadow", @"color", @"text"];
- (void) buildSourceAndIcon
{
    _noseSource = @[@"鼻梁",@"鼻宽"];
    _noseIcon = @[@"contrast",@"saturation"];
    _eyeSource = @[@"内眼角",@"外眼角",@"去眼袋",@"平行双眼皮",@"扇形双眼皮",@"新月双眼皮",@"欧式双眼皮"];
    _eyeIcon = @[@"contrast",@"saturation",@"brightness",@"color",@"contrast",@"hightlight", @"temp"];
    _mouthSource = @[@"微笑",@"上嘴唇",@"下嘴唇"];
    _mouthIcon = @[@"contrast",@"saturation",@"hightlight"];
    _faceSource = @[@"V形脸",@"前额",@"苹果肌",@"凸下巴",@"凹下吧"];
    _faceIcon = @[@"contrast",@"saturation",@"hightlight",@"brightness", @"temp"];
    _beautySource = @[@"美白",@"平滑"];
    _beautyIcon = @[@"contrast",@"saturation"];
}

- (NSString *) getSource:(int) index
{
    return [self getSource:[self getCurrentSelectedIndex] andIndex:index];
}

- (NSString *) getSource:(int)page andIndex:(int)index
{
    switch (page) {
        case INDEX_NOSE: return [self.noseSource objectAtIndex:index];
        case INDEX_EYE: return [self.eyeSource objectAtIndex:index];
        case INDEX_MOUTH: return [self.mouthSource objectAtIndex:index];
        case INDEX_FACE: return [self.faceSource objectAtIndex:index];
        case INDEX_BEAUTY: return [self.beautySource objectAtIndex:index];
    }
    return nil;
}

- (int) getCurrentSelectedIndex
{
    return self.viewController.indexfilterView.selectedIndex;
}
//////////////////////////////////////////
- (void) didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    self.selectedIndex = (int) indexPath.row;
}

- (UICollectionViewCell*) createOrUpdateUICollectionViewCell:(UICollectionViewCell *)cell cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    FilterCell *filtercell = [cell.contentView viewWithTag:1001];
    if (filtercell == nil) {
        CGRect rect = CGRectMake(0, 0, cell.contentView.frame.size.width, cell.contentView.frame.size.height);
        filtercell = [[FilterCell alloc] initWithFrame:rect];
        filtercell.tag = 1001;
        [cell.contentView addSubview:filtercell];
    }
    [self bindFilterCell:filtercell ForItemAtIndexPath: indexPath];
    return [super createOrUpdateUICollectionViewCell:cell cellForItemAtIndexPath:indexPath];
}

- (void) bindFilterCell:(FilterCell*)cell ForItemAtIndexPath:(NSIndexPath *)indexPath
{
    NSArray<NSString *> * source = nil;
    NSArray<NSString *> * icon = nil;
    switch ([self getCurrentSelectedIndex]) {
        case INDEX_NOSE:{
            source = self.noseSource;
            icon = self.noseIcon;
        }break;
        case INDEX_EYE:{
            source = self.eyeSource;
            icon = self.eyeIcon;
        }break;
        case INDEX_FACE:{
            source = self.faceSource;
            icon = self.faceIcon;
        }break;
        case INDEX_MOUTH:{
            source = self.mouthSource;
            icon = self.mouthIcon;
        }break;
        case INDEX_BEAUTY:{
            source = self.beautySource;
            icon = self.beautyIcon;
        }break;
    }
    if(source != nil && icon != nil){
        cell.titleview.text = source[indexPath.row];
        cell.iconview.image = [UIImage imageNamed:icon[indexPath.row]];
    }
}

- (NSInteger) numberOfItemsInSection:(NSInteger)section
{
    switch([self getCurrentSelectedIndex]){
        case INDEX_NOSE: return self.noseSource.count;
        case INDEX_EYE: return self.eyeSource.count;
        case INDEX_FACE: return self.faceSource.count;
        case INDEX_MOUTH: return self.mouthSource.count;
        case INDEX_BEAUTY: return self.beautySource.count;
    }
    return 0;
}

@end
////////////////////////////////////////////////////////////////////////////////////////

static const int TAG_PANNEL_SLIDER = 0;
static const int TAG_PANNEL_COLLECTION = 1;
//////////////////////////////////////////////
@interface ALTransController ()
//////////////////////////////////////////////////////////////////////////
@property(nonatomic,strong) UIView * controlPanel;
@property(nonatomic,strong) SliderPanel * sliderPanel;
@property(nonatomic,assign) int controlPanelTAG;
///////////////////////////////////////////////
@property(nonatomic,strong) LogView * logViewer;
@property(nonatomic,strong) OBJView * objView;
@property(nonatomic,strong) SDKHelper * sdkHelper;
@end

@implementation ALTransController

- (void)viewDidLoad {
[super viewDidLoad];
[self setUpUI];
[self setUpInit];
// Do any additional setup after loading the view, typically from a nib.
}

- (void) setUpUI
{
    CGRect rect = self.view.frame;
    float logpadding = 50;
    float indexpannelHeight = 30;
    float pannelHeight = 150;
    CGRect logpannel = CGRectMake(0, logpadding, rect.size.width, 200);
    CGRect objpannel = CGRectMake(0, 0, rect.size.width, rect.size.height - pannelHeight - indexpannelHeight);
    CGRect indexpannel = CGRectMake(0, rect.size.height - pannelHeight - indexpannelHeight, rect.size.width, indexpannelHeight);
    CGRect controlpannel = CGRectMake(0, rect.size.height - pannelHeight, rect.size.width, pannelHeight);
    [self initControlPanel:controlpannel];
    [self initIndexPanel:indexpannel];
    [self initOBJView:objpannel];
    [self initLogView:logpannel];
}

- (void) setUpInit
{
    _controlPanelTAG = -1;
    //////////////////////
    [self sdkHelperInit:[self copyOBJ]];
}

- (NSString *) copyOBJ
{
    NSString * dir = @"art.scnassets/star";
    dir = [[NSBundle mainBundle] pathForResource:dir ofType:nil];
    NSString * basepath = [NSString stringWithFormat:@"%@/star", [FileUtils getBasePath]];
    NSLog(@"basepath:%@,dir:%@",basepath,dir);
    [FileUtils copyItemAtPath:dir toPath:basepath overwrite:YES error:nil];
    
    
    return basepath;
}

/////////////////////////////////////////////////////////
- (void) initIndexPanel:(CGRect) rect
{
    _indexfilterView = [[ALIndexFilter alloc] initWithFrame:rect];
    [_indexfilterView buildIndexFilter:self];
    [self.view addSubview:_indexfilterView];
}

- (void) initControlPanel:(CGRect) rect
{
    self.controlPanel = [[UIView alloc] initWithFrame:rect];
    CGRect panelrect = CGRectMake(0, 0, rect.size.width, rect.size.height);
    [self addSliderPanel:panelrect];
    _filterView = [[ALFilterView alloc] initWithFrame:panelrect];
    [_filterView buildIndexFilter:self];
    [self.controlPanel addSubview:_filterView];
    [self.view addSubview:self.controlPanel];
}

- (void) initOBJView:(CGRect) rect
{
    self.objView = [[OBJView alloc] initWithFrame:rect];
    [self.view addSubview:self.objView];
}

- (void) initLogView:(CGRect) rect
{
    self.logViewer = [[LogView alloc] initWithFrame:rect];
    [self.view addSubview:self.logViewer];
}
/////////////////////////////////////////////////////////////
- (void)setControlPanelTAG:(int)controlPanelTAG
{
    if(_controlPanelTAG != controlPanelTAG){
        _controlPanelTAG = controlPanelTAG;
        [self switchControlPanel:_controlPanelTAG];
    }
}

- (void) switchControlPanel:(int) tag
{
    switch(tag){
        case TAG_PANNEL_SLIDER:{
            [self.controlPanel bringSubviewToFront:self.sliderPanel];
        }break;
        case TAG_PANNEL_COLLECTION:{
            [self.controlPanel bringSubviewToFront:self.filterView];
        }break;
    }
}
////////////////////// slider pannel //////////////////
- (void) addSliderPanel:(CGRect) rect
{
    _sliderPanel = [[SliderPanel alloc] initWithFrame:rect];
    _sliderPanel.backgroundColor = UIColor.whiteColor;
    [self.controlPanel addSubview:_sliderPanel];
    _sliderPanel.delegate = self;
}

- (void) confirmClick
{
    self.controlPanelTAG = TAG_PANNEL_COLLECTION;
}

- (void) sliderValueChange:(float) value
{
    [self customSliderFilter:self.indexfilterView.selectedIndex
                    andIndex:self.filterView.selectedIndex
                    andValue:value];
}
/////////////////////////////////////////////////////
- (void) selectIndex:(int)index
{
    NSLog(@"selectIndex:%d", index);
    //   [self.logViewer addLog:[NSString stringWithFormat:@"切换形变部位 : %@", [self.indexfilterView getSource:index]]];
    self.controlPanelTAG = TAG_PANNEL_COLLECTION;
    [self.filterView reload];
}

- (void) selectFilter:(int) index
{
    NSLog(@"selectFilter:%d", index);
    //  [self.logViewer addLog:[NSString stringWithFormat:@"切换形变参数 : %@", [self.filterView getSource:index]]];
    if(![self customSelectFilter:self.indexfilterView.selectedIndex andIndex:index]){
        self.controlPanelTAG = TAG_PANNEL_SLIDER;
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
- (BOOL) customSelectFilter:(int)index andIndex:(int)row
{
    switch(index){
        case INDEX_NOSE:{
            
        }break;
        case INDEX_EYE:{
            
            
        }break;
        case INDEX_MOUTH:{
            
            
        }break;
        case INDEX_FACE:{
            //  [self.sdkHelper testShowCompare];
            //模型正在分析中
        
            [self.sdkHelper testEvlo];
        }break;
        case INDEX_BEAUTY:{
            
        }break;
    }
      [self.sdkHelper sliderItemNum:index andRow:row];
    //[self.sdkHelper testEvlo];
    // [self.sdkHelper testShowCompare];
    //  [self.sdkHelper testfifun];
    return NO;
}

- (BOOL) customSliderFilter:(int)index andIndex:(int)row andValue:(float) value
{
    //    NSLog(@"customSliderFilter :%f",value);
    //  [self.logViewer addLog:[NSString stringWithFormat:@"%@, %@: %f",
    //                         [self.indexfilterView getSource:index],
    //                           [self.filterView getSource:index andIndex:row],
    //                           value]
    //  ];
    
    //  [self.logViewer addLog:[NSString stringWithFormat:@"current index=%d , row=%d ,value=%f ",index,row,value]];
    
    
    [self.sdkHelper testtranform:index andRow:row andValue:value/10];
    
    return YES;
}


//////////////////////////////////////////////////////////////////////////////////////
- (void) sdkHelperInit:(NSString *) objfilepath
{
    _sdkHelper = [[SDKHelper alloc] initWithOBJFile:[NSString stringWithFormat:@"%@/chenweiting3d.obj", objfilepath]
                                            andMesh:[NSString stringWithFormat:@"%@/chenweiting3d.jpg", objfilepath]
                                         andOBJView:self.objView
                                     andSliderPanel:self.sliderPanel];
//     [_sdkHelper commitSDKHelperInit];
}


@end
