//
//  FilterCell.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/18.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "FilterCell.h"
#include "UILabelUtils.h"

@implementation FilterCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitFilterCellInit];
    }
    return self;
}

- (void) commitFilterCellInit
{
    CGRect rect = self.frame;
    float padding = 10;
    float maxwidth = rect.size.width - 2*padding;
    float maxheight = rect.size.height - 2*padding;
    _iconview = [[UIImageView alloc] initWithFrame:CGRectMake(padding, padding, maxwidth, maxheight*3/4)];
    _iconview.contentMode = UIViewContentModeCenter;
    [self addSubview:_iconview];
    _titleview = [UILabelUtils createUILabel];
    _titleview.frame = CGRectMake(padding, _iconview.frame.size.height + padding, maxwidth, maxheight/4);
    [self addSubview:_titleview];
}

@end
