//
//  FilterUICollectionView.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/18.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "FilterUICollectionView.h"

@interface FilterUICollectionView()<UICollectionViewDelegate, UICollectionViewDataSource>
@property(nonatomic,strong) UICollectionView *collectionView;
@end

@implementation FilterUICollectionView

- (instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitFilterUICollectionViewInit];
    }
    return self;
}

- (void) commitFilterUICollectionViewInit
{
    UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc] init];
    flowLayout.minimumLineSpacing = 0.0;
    flowLayout.minimumInteritemSpacing = 10.0;
    flowLayout.itemSize = [self createItemSize];
    flowLayout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    [flowLayout invalidateLayout];
    self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:flowLayout];
    [self.collectionView registerClass:[UICollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    self.collectionView.backgroundColor = [UIColor whiteColor];
    self.collectionView.dataSource = self;
    self.collectionView.delegate = self;
    self.collectionView.showsHorizontalScrollIndicator = NO;
    ////////
    [self addSubview:self.collectionView];
    self.collectionView.frame = CGRectMake(0, 0, self.frame.size.width, self.frame.size.height);
}
////////////////////////////////////////////////////////////
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return [self numberOfItemsInSection:section];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    UICollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    return [self createOrUpdateUICollectionViewCell:cell cellForItemAtIndexPath:indexPath];
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [self didSelectItemAtIndexPath:indexPath];
}

////////////////// API /////////////////////////////////////////
- (NSInteger) numberOfItemsInSection:(NSInteger)section
{
    return 0;
}

- (UICollectionViewCell*) createOrUpdateUICollectionViewCell:(UICollectionViewCell *)cell cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return cell;
}

- (void) didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    
}
- (void) reload
{
    @synchronized (self) {
        if(self.collectionView){
            //NSLog(@"collectionView reloadData");
            [self.collectionView reloadData];
        }
    }
}

- (CGSize) createItemSize
{
    return CGSizeMake(100, 100.0);
}

@end
