//
//  SDKHelper.h
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#ifndef SDKHelper_h
#define SDKHelper_h

#include "SceneKitUtils.h"
#include "OBJView.h"
#include "SliderPanel.h"
#import "ALMatchingModel.h"


@protocol SDKHelperDelegate <NSObject>
- (void)analyzeObjFinish;
@end

@interface SDKHelper : NSObject

@property(nonatomic,weak) id<SDKHelperDelegate> delegate;
@property(nonatomic,strong) NSString * srcOBJFile;
@property(nonatomic,strong) NSString * srcMeshFile;
@property(nonatomic,strong) NSString * drcOBJFile;
@property(nonatomic,strong) SCNNode * srcfacehead;

@property (nonatomic, strong) NSString *goalOBJFile;
@property (nonatomic, strong) NSString *goalMeshFile;

- (instancetype)initWithOBJFile:(NSString *)file andMesh:(NSString *) meshfile andOBJView:(OBJView*) objview andSliderPanel:(SliderPanel*) sliderPanel;

- (void) testtranform:(int)index andRow:(int)row andValue:(float) rate;

- (instancetype)initWithOBJView:(OBJView*) objview andModel:(ALMatchingModel *)model andSliderPanel:(SliderPanel *)sliderPanel;

- (void) sliderItemNum:(int)index andRow:(int)row;


-(void) testfitfun;

-(void) testEvlo;

-(void) testShowCompare;

//把所需要的模型
- (void)commitSDKHelperInit;

//展示模型
- (void)testloadFileData;

//获取自己的转化的节点
- (SCNNode *)getMy3DNode;
@end

#endif /* SDKHelper_h */
