//
//  SliderPanel.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/18.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "SliderPanel.h"

#include "UIButtonUtils.h"

#include "FilterSlider.h"

@interface SliderPanel()
@property (nonatomic,strong) FilterSlider * slider;
@property (nonatomic, strong) UIButton *confirmBtn;
@end

@implementation SliderPanel

- (instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitSliderPanelinit];
    }
    return self;
}

- (void) commitSliderPanelinit
{
    CGRect rect = self.frame;
    float buttonHeight = 50;
    //////////
    self.slider = [[FilterSlider alloc] initWithFrame:CGRectMake(25, 0, rect.size.width - 50, rect.size.height - buttonHeight)];
    self.slider.value = 0;
    self.slider.minimumValue = -100.0;
    self.slider.maximumValue = 100.0;
    self.slider.continuous = NO;
    [self.slider addTarget:self action:@selector(updateSlider) forControlEvents:UIControlEventValueChanged];
    [self addSubview:self.slider];
    self.confirmBtn.frame = CGRectMake((rect.size.width-150)/2, self.frame.size.height-buttonHeight, 150, buttonHeight);
    [self addSubview:self.confirmBtn];
    [self.confirmBtn addTarget:self action:@selector(confirmBtnCLick) forControlEvents:UIControlEventTouchUpInside];
}

-(UIButton *)confirmBtn
{
    if(!_confirmBtn){
        _confirmBtn = [UIButtonUtils createUIButton];
        [_confirmBtn setTitle:@"完成" forState:UIControlStateNormal];
    }
    return _confirmBtn;
}
////////////////////////////////////////////////////////////////////
- (void) confirmBtnCLick
{
    if(self.delegate && [self.delegate respondsToSelector:NSSelectorFromString(@"confirmClick")]){
        [_delegate confirmClick];
    }
}

- (void) updateSlider
{
    if(self.delegate && [self.delegate respondsToSelector:NSSelectorFromString(@"sliderValueChange:")]){
        [_delegate sliderValueChange:[self getCurrentValue]];
    }
}
/////////////////////////////
- (float) getCurrentValue
{
    return self.slider.value;
}
/////////
- (void) setCurrentValue:(float) value
{
    self.slider.value = value;
}
@end
