//
//  FileUtils.h
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#ifndef FileUtils_h
#define FileUtils_h

@interface FileUtils : NSObject

+ (NSString *) getBasePath;

+ (BOOL) createPath:(NSString *) path;

+ (BOOL) delPath:(NSString *) path;

+ (BOOL) isPathExist:(NSString *)dirPath;

+ (BOOL) isFileExist:(NSString *)filename;

+ (NSMutableString *) loadNSMutableStringFileContent:(NSString *) filename;

+ (BOOL) saveNSMutableStringFile:(NSMutableString *)configs filename:(NSString *) filename;

+ (BOOL) copyItemAtPath:(NSString *)path toPath:(NSString *)toPath overwrite:(BOOL)overwrite error:(NSError **)error;

+ (BOOL) copyArt:(NSString *)path toPath:(NSString *)toPath overwrite:(BOOL)overwrite;

@end

#endif /* FileUtils_h */
