//
//  FileUtils.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "FileUtils.h"
#include "FCFileManager.h"

@implementation FileUtils

+ (NSString *) getBasePath
{
    NSArray *array =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    return [array objectAtIndex:0];
}

+ (BOOL) delPath:(NSString *) path
{
    NSFileManager *fileManager = [NSFileManager defaultManager];
    return [fileManager removeItemAtPath:path error:nil];
}

+ (BOOL) createPath:(NSString *) path
{
    BOOL isDir = NO;
    NSFileManager *fileManager = [NSFileManager defaultManager];
    BOOL existed = [fileManager fileExistsAtPath:path isDirectory:&isDir];
    if ( !(isDir == YES && existed == YES) )
    {
        return [fileManager createDirectoryAtPath:path withIntermediateDirectories:YES attributes:nil error:nil];
    }
    return YES;
}

+ (BOOL)isFileExist:(NSString *)filename
{
    if(filename && [FCFileManager isFileItemAtPath:filename]){
        return [FCFileManager existsItemAtPath:filename];
    }
    return NO;
}

+ (BOOL)isPathExist:(NSString *)dirPath
{
    if([FCFileManager isDirectoryItemAtPath:dirPath]){
        return [FCFileManager existsItemAtPath:dirPath];
    }
    return NO;
}

+ (NSMutableString *) loadNSMutableStringFileContent:(NSString *) filename
{
    NSMutableString * filehole = [NSMutableString stringWithContentsOfFile:filename encoding:NSUTF8StringEncoding error:nil];
    return filehole;
}

+ (BOOL) saveNSMutableStringFile:(NSMutableString *)configs filename:(NSString *) filename
{
    return [configs writeToFile:filename atomically:YES encoding:NSUTF8StringEncoding error:nil];
}

+ (BOOL) copyItemAtPath:(NSString *)path toPath:(NSString *)toPath overwrite:(BOOL)overwrite error:(NSError **)error
{
    return [FCFileManager copyItemAtPath:path toPath:toPath overwrite:overwrite error:error];
}

+ (BOOL) copyArt:(NSString *)path toPath:(NSString *)toPath overwrite:(BOOL)overwrite
{
    //NSString * dir = @"art.scnassets/test";
    NSString * dir = [[NSBundle mainBundle] pathForResource:path ofType:nil];
    return [FileUtils copyItemAtPath:dir toPath:toPath overwrite:YES error:nil];
}

@end
