//
//  SceneKitUtils.h
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#ifndef SceneKitUtils_h
#define SceneKitUtils_h

#import <SceneKit/SceneKit.h>

@interface SceneKitUtils : NSObject
+ (void) scaleSCNNode:(SCNNode *) node byScale:(float)scalevalue;
+ (SCNScene *) loadSCNSceneFromLocalFile:(NSString *) filename;
+ (SCNScene *) loadSCNSceneFromArtFile:(NSString *) filename;
+ (void) removeAllChildNodes:(SCNNode*)scnnode;
/////////////////////////////////////////////////////////////////////////////
+ (NSString *) debugSCNGeometrySource:(SCNGeometrySource*)source;
+ (NSString *) debugSCNGeometryElement:(SCNGeometryElement*)element;
+ (NSString *) debugSCNGeometry:(SCNGeometry*)geometry;
@end

#endif /* SceneKitUtils_h */
