//
//  SceneKitUtils.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "SceneKitUtils.h"

#include "FileUtils.h"

@implementation SceneKitUtils

+ (void) scaleSCNNode:(SCNNode *) node byScale:(float)scalevalue
{
    node.scale = SCNVector3Make(node.scale.x * scalevalue, node.scale.y * scalevalue, node.scale.z * scalevalue);
}

+ (SCNScene *) loadSCNSceneFromLocalFile:(NSString *) filename
{
    return [SCNScene sceneWithURL:[NSURL fileURLWithPath:filename]
                          options:nil error:nil];
}

+ (SCNScene *) loadSCNSceneFromArtFile:(NSString *) filename
{
     return [SCNScene sceneNamed:filename];
}

+ (void) removeAllChildNodes:(SCNNode*)scnnode
{
    NSEnumerator * enumerateor =  [scnnode.childNodes objectEnumerator];
    SCNNode * child;
    while (child = [enumerateor nextObject]) {
        [child removeFromParentNode];
    }
}

//////////////////////////////////////////////////////////
+ (NSString *) debugSCNGeometrySource:(SCNGeometrySource*)source
{
    return [NSString stringWithFormat:@"{componentsPerVector:%zi,vectorCount:%zi, bytesPerComponent:%zi, \
            dataStride:%zi, floatComponents:%d, semantic:%@,dataOffset:%zi, %zi}",
          source.componentsPerVector, source.vectorCount, source.bytesPerComponent,
          source.dataStride, source.floatComponents, source.semantic, source.dataOffset, source.data.length];
}

+ (NSString *) debugSCNGeometryElement:(SCNGeometryElement*)element
{
    return [NSString stringWithFormat:@"{primitiveCount:%zi, primitiveType:%zi, bytesPerIndex:%zi, length:%zi}",
          element.primitiveCount, element.primitiveType, element.bytesPerIndex, element.data.length];
}

+ (NSString *) debugSCNGeometry:(SCNGeometry*)geometry
{
    NSString * tt = [NSString stringWithFormat:@"geometry:%zi, geometryElements:%zi, geometryElementCount:%zi",
          geometry.geometrySources.count,
          geometry.geometryElements.count,
          geometry.geometryElementCount];
    NSString * detail = @"";
    for(int index=0; index<geometry.geometryElements.count; index++){
        SCNGeometryElement * element = [geometry.geometryElements objectAtIndex:index];
        detail = [detail stringByAppendingString:@"\n"];
        detail = [detail stringByAppendingString:[SceneKitUtils debugSCNGeometryElement:element]];
    }
    for(int index=0; index<geometry.geometrySources.count; index++){
        SCNGeometrySource * source = [geometry.geometrySources objectAtIndex:index];
        detail = [detail stringByAppendingString:@"\n"];
        detail = [detail stringByAppendingString:[SceneKitUtils debugSCNGeometrySource:source]];
    }
    return [NSString stringWithFormat:@"%@%@", tt, detail];
}

@end
