//
//  UnOSUtils.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "UnOSUtils.h"

@implementation UnOSUtils

+ (NSString *) formatDataStr:(NSDate*)date withFormat:(NSString *) format
{
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];// 创建一个时间格式化对象
    [dateFormatter setDateFormat:format];//设定时间格式,这里可以设置成自己需要的格式
    return [dateFormatter stringFromDate:date];//将时间转化成字符串
}

+ (NSString *) tranformDateStr:(long) time
{
    return [UnOSUtils tranformDateStr:time withFormat:FROMAT_DATE_1];
}

+ (NSString *) tranformDateStr:(long) time withFormat:(NSString *) format
{
    NSDate *date = [NSDate dateWithTimeIntervalSince1970:time];
    return [UnOSUtils formatDataStr:date withFormat:format];
}

//获取当前时间
+ (NSString *)currentDateStr
{
    NSDate *currentDate = [NSDate date];//获取当前时间，日期
    return [UnOSUtils formatDataStr:currentDate withFormat:FROMAT_DATE_1];
}

+ (NSString *)currentMillsString
{
    return  [NSString stringWithFormat:@"%ld", (long)[[NSDate date] timeIntervalSince1970]];
}

+ (long) currentMills
{
    return (long)([[NSDate date] timeIntervalSince1970] * 1000);
}

+ (NSString *) getNSString:(const char *) string
{
    return  [[NSString alloc] initWithUTF8String:string];
}

+ (const char *) getCString:(NSString *) string
{
    return [string UTF8String];
}

@end
