//
//  LogView.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>

#include "LogView.h"

@interface LogView()<UITextViewDelegate>
@end

@implementation LogView

- (instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitLogViewInit];
    }
    return self;
}

- (void) commitLogViewInit
{
    self.editable = NO;
    self.font = [UIFont systemFontOfSize:20.0];
    self.textColor = [UIColor blueColor];
    self.backgroundColor = UIColor.clearColor;
    self.layoutManager.allowsNonContiguousLayout = NO;
    self.autoresizingMask =  UIViewAutoresizingFlexibleHeight |
                             UIViewAutoresizingFlexibleLeftMargin |
                             UIViewAutoresizingFlexibleRightMargin |
                             UIViewAutoresizingFlexibleWidth;
    self.delegate = self;
}

- (void) addLog:(NSString *) log
{
    self.text = [self.text stringByAppendingFormat:@"\n%@", log];
    [self scrollToLast];
}

- (void) scrollToLast
{
    [self scrollRangeToVisible:NSMakeRange(self.text.length, 1)];
}

@end
