//
//  OBJView.m
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/19.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "OBJView.h"
#import <SceneKit/ModelIO.h>
#import "FileUtils.h"
#import "SDKHelper.h"

#define TAG_LIGHT @"LIGHT"
@interface OBJView()

@end
@implementation OBJView

-(instancetype)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame]){
        [self commitOBJViewInit];
    }
    return self;
}

- (void) commitOBJViewInit
{
    _scnview = [[SCNView alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width, self.frame.size.height)];
    _scnview.backgroundColor = UIColor.blackColor;
    _scnview.allowsCameraControl = YES;
    _scnview.showsStatistics = NO;
    _scnview.scene = [SCNScene new];
    [self addSubview:_scnview];
}

- (SCNNode *) createSCNNode
{
    SCNNode * lightNode = [SCNNode new];
    lightNode.name = TAG_LIGHT;
    lightNode.light = [SCNLight new];
    lightNode.light.color = UIColor.whiteColor;
    lightNode.light.type = SCNLightTypeDirectional;
    return lightNode;
}

/*
- (void) loadLocalFile:(NSString *) objfile andMesh:(NSString *) file
{
    _objfilename = objfile;
    _meshfilename = file;
    [self reload];
}
- (void) loadfaceScnnode:(SCNNode *)facehead andMesh:(NSString *)file
{
    _faceheadname = facehead;
    _meshfilename = file;
    [self reload];
}
*/
- (void)loadMyOBjModel:(ALMatchingModel *)model {
    if (![model.sourceOBJFile isNonEmpty]) {
        [AppDelegate.visibleController toast:@"模型不存在"];
        return;
    }
    
    if (![FileUtils isFileExist:model.sourceOBJFile]) {
        [AppDelegate.visibleController toast:@"模型不存在"];
        return;
    }
    
    SCNScene * scene = [SceneKitUtils loadSCNSceneFromLocalFile:model.sourceOBJFile];
    SCNNode * head = scene.rootNode.childNodes[0];
    //    SCNNode * newhead = self.faceheadname;
    head.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
    head.geometry.firstMaterial.diffuse.contents = model.sourceMeshFile;
    head.name = @"customHead";
    self.scnview.scene = scene;
}
- (void)setObjfilename:(NSString *)objfilename
{
    _objfilename = objfilename;
    [self reload];
}

- (void) setMeshfilename:(NSString *)meshfilename
{
    _meshfilename = meshfilename;
    [self reload];
}

//- (void) reloadMyobjModel:(ALMatchingModel *)model {
//    if (![model.sourceOBJFile isNonEmpty]) {
//        [AppDelegate.visibleController toast:@"模型不存在"];
//        return;
//    }
//
//    if (![FileUtils isFileExist:self.objfilename]) {
//        [AppDelegate.visibleController toast:@"模型不存在"];
//        return;
//    }
//    self.scnview.scene = [self createSCNScene];
//    self.scnview.scene.rootNode.name = @"customHead";
//}
- (SCNScene *) createSCNScene
{
    SCNScene * scene = [SceneKitUtils loadSCNSceneFromLocalFile:self.objfilename];
    SCNNode * head = scene.rootNode.childNodes[0];
    head.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
    head.geometry.firstMaterial.diffuse.contents = self.meshfilename;
    return scene;
}
- (void)setFaceheadname:(SCNNode *)faceheadname
{
    _faceheadname = faceheadname;
    [self reload];
}

- (void) reload
{
    if(_faceheadname && _meshfilename){
        _faceheadname.name = @"customHead";
        _faceheadname.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
        _faceheadname.geometry.firstMaterial.diffuse.contents = self.meshfilename;
        ////////////////////////////////////
        SCNNode * oldhead = [self.scnview.scene.rootNode childNodeWithName:@"customHead" recursively:NO];
        if(oldhead){
            [oldhead removeFromParentNode];
            NSLog(@"11111111");
        }
        NSLog(@"222222222");
        [self.scnview.scene.rootNode addChildNode:_faceheadname];
    }
}

- (void)reloadWithMyModel:(ALMatchingModel *)model andStarObj:(NSString *)starFile and3DNode:(SCNNode *)my3Dnode {
    
    SCNScene * scene = [SCNScene sceneWithURL:[NSURL fileURLWithPath:model.sourceOBJFile]
                                      options:nil error:nil];
    SCNNode * head = scene.rootNode.childNodes[0];
    head.name = @"customHead";
    head.geometry.firstMaterial.lightingModelName = SCNLightingModelBlinn;
    head.geometry.firstMaterial.diffuse.contents  = model.sourceMeshFile;
    self.scnview.scene = scene;
    if (ALScanManager.shareInstance.isScan3D) {
        SCNNode * oldhead = [self.scnview.scene.rootNode childNodeWithName:@"customHead" recursively:NO];
        if(oldhead){
            [oldhead removeFromParentNode];
        }
        [self.scnview.scene.rootNode addChildNode:my3Dnode];
    }
    
    SCNScene *goalScene = [SCNScene sceneWithURL:[NSURL fileURLWithPath:starFile]
                                      options:nil error:nil];
    SCNNode *goalHead = goalScene.rootNode.childNodes[0];
    SCNMaterial *clearMaterial = SCNMaterial.material;
    clearMaterial.diffuse.contents = UIColor.blueColor;
    clearMaterial.transparency = 0.3;
    SCNVector3 position = goalHead.position;
    goalHead.position = SCNVector3Make(position.x , position.y , position.z);
    if (@available(iOS 11.0, *)){
        clearMaterial.fillMode = SCNFillModeLines;
    }
    goalHead.geometry.firstMaterial = clearMaterial;
    goalHead.geometry.firstMaterial.selfIllumination.contents = UIColor.blueColor;
    [self.scnview.scene.rootNode addChildNode:goalHead];
    
}
@end
