//
//  ALMatchingController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/27.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALMatchingController.h"
#include "LogView.h"
#include "OBJView.h"
#include "FileUtils.h"
#include "SDKHelper.h"
#import "ALScanManager.h"

@interface ALMatchingController ()
@property(nonatomic,strong) LogView * logViewer;
@property(nonatomic,strong) OBJView * objView;
@property(nonatomic,strong) SDKHelper * sdkHelper;

@property (nonatomic, strong) NSString *basePath;
@end

@implementation ALMatchingController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.objView = [[OBJView alloc] initWithFrame:CGRectMake(0, OCNavigationBar.barHeight, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT-64)];
    [self.view addSubview:self.objView];
    
    [self setUpInit];
    self.basePath = [self copyOBJ];
    self.navigationBar.rightTitle = @"拟合";
    self.navigationBar.nearRightTitle = @"张智霖(1)";
}
- (void)nearRightButtonClicked:(OCNavigationBarButton *)button {
    button.selected = !button.selected;
    NSString * dir = @"art.scnassets/star";
    
    //TODO 待删除
    NSString *objFile;
    NSString *meshFile;
    if (ALScanManager.shareInstance.isScan3D) {
        //加载3d下文件
        objFile = [ALScanManager.shareInstance.show3DInfo getOBJFile]; //存本地
        meshFile = [ALScanManager.shareInstance.show3DInfo getMeshFile]; //存本地
    } else {
        //加载2d下文件
        objFile = [ALScanManager.shareInstance.show2DPathInfo getOBJFile]; //存本地
        meshFile =[ALScanManager.shareInstance.show2DPathInfo getMeshFile]; //存本地
    }
    ALMatchingModel *model = [[ALMatchingModel alloc] init];
    model.sourceOBJFile = objFile;
    model.sourceMeshFile = meshFile;
    
    NSString *pathDir = [[NSBundle mainBundle] pathForResource:@"art.scnassets/star" ofType:nil];
    if (button.selected) {
         self.navigationBar.nearRightTitle = @"张智霖";
        model.goalOBJFile = [NSString stringWithFormat:@"%@/nan43xiaolixun.obj",pathDir];
        model.goalMeshFile = [NSString stringWithFormat:@"%@/nan43xiaolixun.jpg",pathDir];
        dir = [[NSBundle mainBundle] pathForResource:dir ofType:nil];
        _sdkHelper = [[SDKHelper alloc] initWithOBJView:self.objView andModel:model andSliderPanel:nil];
    } else {
        self.navigationBar.nearRightTitle = @"切换xiaolixun";
        model.goalOBJFile = [NSString stringWithFormat:@"%@/head3dzhangzhilin.obj",pathDir];
        model.goalMeshFile = [NSString stringWithFormat:@"%@/head3dzhangzhilin.jpg",pathDir];
        dir = [[NSBundle mainBundle] pathForResource:dir ofType:nil];
        _sdkHelper = [[SDKHelper alloc] initWithOBJView:self.objView andModel:model andSliderPanel:nil];
    }
    
}
- (void)rightButtonClicked:(OCNavigationBarButton *)button {
    [self showLoading:@"模型数据分析中"];
    [self.sdkHelper testEvlo];
}
- (void) setUpInit
{
    //////////////////////
    [self sdkHelperInit:self.basePath];
}
- (NSString *) copyOBJ
{
    NSString * dir = @"art.scnassets/star";
    dir = [[NSBundle mainBundle] pathForResource:dir ofType:nil];
    NSString * basepath = [NSString stringWithFormat:@"%@/star", [FileUtils getBasePath]];
    NSLog(@"basepath:%@,dir:%@",basepath,dir);
    [FileUtils copyItemAtPath:dir toPath:basepath overwrite:YES error:nil];
    
    
    return basepath;
}


//////////////////////////////////////////////////////////////////////////////////////
- (void) sdkHelperInit:(NSString *) objfilepath
{
    if (self.showInfo) {
        _sdkHelper = [[SDKHelper alloc] initWithOBJFile:[self.showInfo getOBJFile]
                                                andMesh:[self.showInfo getMeshFile]
                                             andOBJView:self.objView
                                         andSliderPanel:nil];
    } else {
        NSString *objFile;
        NSString *meshFile;
        if (ALScanManager.shareInstance.isScan3D) {
            //加载3d下文件
            objFile = [ALScanManager.shareInstance.show3DInfo getOBJFile]; //存本地
            meshFile = [ALScanManager.shareInstance.show3DInfo getMeshFile]; //存本地
        } else {
            //加载2d下文件
            objFile = [ALScanManager.shareInstance.show2DPathInfo getOBJFile]; //存本地
            meshFile =[ALScanManager.shareInstance.show2DPathInfo getMeshFile]; //存本地
        }
        ALMatchingModel *model = [[ALMatchingModel alloc] init];
        model.sourceOBJFile = objFile;
        model.sourceMeshFile = meshFile;
        
        NSString * dir = @"art.scnassets/star";
        dir = [[NSBundle mainBundle] pathForResource:dir ofType:nil];
        NSString * basepath = [NSString stringWithFormat:@"%@/star", [FileUtils getBasePath]];
        NSLog(@"basepath:%@,dir:%@",basepath,dir);
        [FileUtils copyItemAtPath:dir toPath:basepath overwrite:YES error:nil];
        model.goalOBJFile = [NSString stringWithFormat:@"%@/head3dzhangzhilin.obj",basepath];
        model.goalMeshFile = [NSString stringWithFormat:@"%@/head3dzhangzhilin.jpg",basepath];
        _sdkHelper = [[SDKHelper alloc] initWithOBJView:self.objView andModel:model andSliderPanel:nil];
        
    }
    
}

@end
