//
//  AL2DCaptureInfo.m
//  GMAlpha
//
//  Created by Q14 on 2018/12/4.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "AL2DCaptureInfo.h"
@interface AL2DCaptureInfo()
@property (nonatomic, strong) NSString *CustomFileName;
@end
@implementation AL2DCaptureInfo
-(instancetype)initWithBasePath:(NSString *)basepath
{
    if(self == [super init]){
        _basePath = basepath;
        [self commitBellus2DCaptureInfoInit];
    }
    return self;
}

- (void) commitBellus2DCaptureInfoInit
{
    _CustomFileName = @"model";
}

- (NSString *) getFileName//获取当前的文件名
{
    return _CustomFileName;
}

- (NSString *) getOBJFile//获取当前 obj 文件路径。
{
    return [NSString stringWithFormat:@"%@/%@.obj", _basePath, _CustomFileName];
}

- (NSString *) getMeshFile//获取当前贴图文件路径
{
    return [NSString stringWithFormat:@"%@/%@.png", _basePath, _CustomFileName];
}

- (NSString *)description
{
    return [NSString stringWithFormat:@"{basePath:%@, CustomFileName:%@, objfile:%@, meshfile:%@}",
            _basePath,
            _CustomFileName,
            [self getOBJFile],
            [self getMeshFile]];
}


- (instancetype)initWithCoder:(NSCoder *)aDecoder {
    if (self = [super init]) {
        self.basePath= [aDecoder decodeObjectForKey:@"basePath"];
        self.CustomFileName= [aDecoder decodeObjectForKey:@"CustomFileName"];
    }
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder {
    [aCoder encodeObject:self.basePath forKey:@"basePath"];
    [aCoder encodeObject:self.CustomFileName forKey:@"CustomFileName"];
}
@end
