//
//  ALScanManager.h
//  GMAlpha
//
//  Created by Q14 on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ALUnre2DViewController.h"
#import "AL3DCaptureController.h"
#import "Unre3DAR3DCaptureInfo.h"
#import "AL2DCaptureInfo.h"

@interface ALScanManager : NSObject
+ (ALScanManager *) shareInstance;

@property (nonatomic, strong) ALUnre2DViewController *capture2Dvc;
@property (nonatomic, strong) AL3DCaptureController *capture3Dvc;

//是否是深度相机
@property (nonatomic, assign) BOOL isScan3D;

@property (nonatomic, strong) NSString *scan3DPath;

@property(nonatomic, strong) Unre3DAR3DCaptureInfo *show3DInfo;

//拟合后的3D 信息
@property(nonatomic, strong) Unre3DAR3DCaptureInfo *fitting3DInfo;

//传一个根路径 取出目录下 model.obj  model.png
@property(nonatomic, strong) AL2DCaptureInfo *show2DPathInfo;

@property (nonatomic, strong) NSString *fittingId;
@property (nonatomic, strong) NSString *fittingTempId;
@property (nonatomic, assign) NSInteger fittingCnt; //拟合明星数量


//最后一次拟合的obj  对象路径
@property (nonatomic, strong) NSString *lastMatchingPath;
@property (nonatomic, assign) BOOL needUploadShareObj;

- (NSMutableArray *)allFilesAtPath:(NSString *)direString;

- (void)savePathInfo;
//1. 保留一个拍照id
//2. 根据拍照id 获得本地是否有3d 模型
//3. 有就展示
@end
