//
//  ALScanManager.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALScanManager.h"
#import "FileUtils.h"
@implementation ALScanManager
static ALScanManager* _instance = nil;
+(instancetype) shareInstance
{
    static dispatch_once_t onceToken ;
    dispatch_once(&onceToken, ^{
        _instance = [[super allocWithZone:NULL] init] ;
    
        
    }) ;
    return _instance ;
}

+(id) allocWithZone:(struct _NSZone *)zone
{
    return [ALScanManager shareInstance] ;
}

-(id) copyWithZone:(struct _NSZone *)zone
{
    return [ALScanManager shareInstance] ;
}

- (NSMutableArray *)allFilesAtPath:(NSString *)direString
{
    NSMutableArray *pathArray = [NSMutableArray array];
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSArray *tempArray = [fileManager contentsOfDirectoryAtPath:direString error:nil];
    for (NSString *fileName in tempArray) {
        BOOL flag = YES;
        NSString *fullPath = [direString stringByAppendingPathComponent:fileName];
        if ([fileManager fileExistsAtPath:fullPath isDirectory:&flag]) {
            if (!flag) {
                // ignore .DS_Store
                if (![[fileName substringToIndex:1] isEqualToString:@"."]) {
                    [pathArray addObject:fullPath];
                }
            }
            else {
                [pathArray addObject:[self allFilesAtPath:fullPath]];
            }
        }
    }
    
    return pathArray;
}

- (void)savePathInfo {
    
    //user属于用户重要数据，如果存储在沙河cache目录下，当系统内存紧张时候，系统可能会删除user数据，所以必须存储在Document目录下
    if (self.show3DInfo) {
        [GMCache storeObjectAtDocumentPathWithkey:@"save3DPath" object:_show3DInfo block:nil];
    }
    
    if (self.fittingId) {
        [GMCache storeObjectAtDocumentPathWithkey:@"saveAlpgafittingId" object:_fittingId block:nil];
    }
    
    if (self.show2DPathInfo) {
        [GMCache storeObjectAtDocumentPathWithkey:@"save2DPath" object:_show2DPathInfo block:nil];
    }
    
    [GMCache storeObjectAtDocumentPathWithkey:@"isScan3D" object:_isScan3D ? @"1" : @"" block:nil];
    
    if ([self.lastMatchingPath isNonEmpty]) {
        [GMCache storeObjectAtDocumentPathWithkey:@"lastMatchingPathObj" object:_lastMatchingPath block:nil];
    }
    if (self.fitting3DInfo) {
        [GMCache storeObjectAtDocumentPathWithkey:@"saveFittingOBjPath" object:_fitting3DInfo block:nil];
    }
 
    
}

- (NSString *)fittingId {
    if (!_fittingId) {
        NSString *fid =  [GMCache fetchObjectAtDocumentPathWithkey:@"saveAlpgafittingId"];
        if (fid) {
            _fittingId = fid;
        }
    }
   return _fittingId;
}

- (NSString *)lastMatchingPath {
    if (![_lastMatchingPath isNonEmpty]) {
        NSString *lastObj =  [GMCache fetchObjectAtDocumentPathWithkey:@"lastMatchingPathObj"];
        if (lastObj) {
            _lastMatchingPath = lastObj;
        }
    }
    return _lastMatchingPath;
}
- (BOOL)isScan3D {
    if (!_isScan3D) {
         NSString *scan3D=  [GMCache fetchObjectAtDocumentPathWithkey:@"isScan3D"];
        if ([scan3D isNonEmpty]) {
            _isScan3D = YES;
        }
    }
    return _isScan3D;
}
- (Unre3DAR3DCaptureInfo *)show3DInfo {
    if (!_show3DInfo) {
        Unre3DAR3DCaptureInfo *u3DInfo=  [GMCache fetchObjectAtDocumentPathWithkey:@"save3DPath"];
        if (u3DInfo) {
            
            u3DInfo.basePath =  [NSString stringWithFormat:@"%@/capture/alphaCapture3d", [FileUtils getBasePath]]; 
            _show3DInfo = u3DInfo;
        }
    }
    return _show3DInfo;
}
- (Unre3DAR3DCaptureInfo *)fitting3DInfo {
    if (_fitting3DInfo) {
        Unre3DAR3DCaptureInfo *fittingInfo=  [GMCache fetchObjectAtDocumentPathWithkey:@"saveFittingOBjPath"];
        fittingInfo.CustomFileName = @"alphaSharePath";
        if (fittingInfo) {
            fittingInfo.basePath = [NSString stringWithFormat:@"%@/fittedFloder", [FileUtils getBasePath]];
            _fitting3DInfo = fittingInfo;
        }
    }
    return _fitting3DInfo;
}

- (AL2DCaptureInfo *)show2DPathInfo {
    if (!_show2DPathInfo) {
        AL2DCaptureInfo *u2DInfo=  [GMCache fetchObjectAtDocumentPathWithkey:@"save2DPath"];
        if (u2DInfo) {
            u2DInfo.basePath = [NSString stringWithFormat:@"%@/alphaCapture2D", [FileUtils getBasePath]];
            _show2DPathInfo = u2DInfo;
        }
    }
    return _show2DPathInfo;
}


@end
