//
//  AL3DCaptureController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "AL3DCaptureController.h"
#import "ALAR3DCaptureView.h"
#import "FaceShowViewController.h"
#import "ALMatchingController.h"
#import "AppDelegate+ViewControl.h"
#import "ALScanFaceCompleteViewController.h"

#import <Unre2DScanLib/U2DHeadScanner.h>
#import <Unre2DScanLib/U2DHeadNetModel.h>
#import <Unre2DScanLib/U2DHeadSimilarity.h>
#import "ALUpLoadManager.h"
#import "ALScanManager.h"
#import "ALFaceSDK.h"
#import "ALCaptureUtils.h"
#import "ALScanPlayerView.h"
#import "ALFaceFittingManager.h"

@interface AL3DCaptureController()<ALCaptureViewDegelate>

@property (nonatomic, strong) ALFaceSDK *faceSDK;
/** netPath对应raw_similar_data */
@property (nonatomic, copy) NSString *netPath;
/** bmpPath对应pre_uv_url */
@property (nonatomic, copy) NSString *bmpPath;
/** 数据请求成功后获得的id */
@property (nonatomic, copy) NSString *resultId;
// 轮寻
@property (nonatomic, strong) NSTimer *timer;
/** 获取UV图的接口传回的数据 */
@property (nonatomic, copy) NSString *uvUrl;

@property (nonatomic, strong) ALCaptureUtils *captureUtils;
@end
@implementation AL3DCaptureController
- (void)initController {
    [super initController];
    
    self.pageName = @"face_scan";
    [Phobos track:@"page_view" attributes:@{@"page_name" : self.pageName}];
    _captureUtils = [[ALCaptureUtils alloc] init];
}
- (void)dealloc
{
    [self.timer invalidate];
    self.timer = nil;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    self.captureview = [[ALAR3DCaptureView alloc] initWithFrame:CGRectMake(0, OCNavigationBar.barHeight, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight)];
    self.captureview.delegate = self;
    self.captureview.backgroundColor = UIColor.whiteColor;
    [self.view addSubview:self.captureview];
    self.title = @"模拟";
    self.navigationBar.rightIcon = @"scan_3d_right";
    [self.navigationBar setButtonMargin:15];
}

- (void)backAction:(OCNavigationBarButton *)button {
    [super backAction:button];
    [Phobos track:@"page_click_return_label" attributes:@{@"page_name":self.pageName}];
}

-(void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self.captureview viewDidAppear:animated];
}

-(void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.navigationController.navigationBar.hidden = YES;
    [self.captureview viewWillAppear:animated];
}

-(void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    self.navigationController.navigationBar.hidden = NO;
    [self.captureview viewWillDisappear:animated];
}

- (void)rightButtonClicked:(OCNavigationBarButton *)button {
    ALScanPlayerView *playView = [[ALScanPlayerView alloc] init];
    [self.view addSubview:playView];
}

////////////// ARCaptureViewDegelate /////////////////
- (void)onCaputreClick {
    [Phobos track:@"face_scan_click_shutter" attributes:@{@"page_name":self.pageName}];
}

- (BOOL) onCaptureFinish:(Unre3DAR3DCaptureInfo *)captureinfo {
    BOOL isNeedRequest = [GMLoginManager shareInstance].user.has_scanFace;
    if (isNeedRequest) [ALFaceFittingManager shareInstance].isNeedRequest = YES;
    
    if(captureinfo){
        NSString *imgPath = [captureinfo.basePath stringByAppendingString:@"/unrecustom_source.jpg"];
        ALScanManager.shareInstance.show3DInfo = captureinfo;
        U2DHeadNetModel* u2dModel  =  [[U2DHeadNetModel alloc]init];
        _captureUtils.u2dModel = u2dModel;
        NSString * netImgFile = [captureinfo.basePath stringByAppendingString:@"/formatNet.jpg"];
        NSString * uvImgFile = [captureinfo.basePath stringByAppendingString:@"/formatUV.jpg"];
        U2DModelTF tff;
        BOOL isSuccess =  [u2dModel formatNetImageWithInImgFile:imgPath andnetImgFile:netImgFile uvImgFile:uvImgFile getModelTF:&tff];
        _captureUtils.tff_net = tff;
        //相似度
        U2DHeadSimilarity *u2dSim = [[U2DHeadSimilarity alloc]init];
        // 定义源图片路径
        NSString * inImg = imgPath;
        // 定义个变量，用于承接生成的bmp的路径 --规则是在源图片目录下生成一张 同名capImg_similar.bmp 的图片
        NSString * simImg;
        [u2dSim headFaceSimilarityWithInImg:inImg andOutImg:&simImg];
        if (isSuccess) {
            UIImage *netImage = [UIImage imageWithContentsOfFile:netImgFile];
            UIImage *bmpImage = [UIImage imageWithContentsOfFile:simImg];
            //unrecustom_source.jpg
            NSString *originImg = [captureinfo.basePath stringByAppendingString:@"/unrecustom_source.jpg"];
            _captureUtils.originCapImgFile = originImg;
            _captureUtils.createUV = NO;
            //异步处理 上传图片生成 obj
            [_captureUtils uploadNetImage:netImage BmpImage:bmpImage complete:^(BOOL isSuccess) {
                
            }];
        }
        
        //获取自己model据成功
        [[NSNotificationCenter defaultCenter] postNotificationName:kcapture3DModelAndStartModelSuccess object:nil];
    }
    
    return YES;
}

- (void) onCaptureStateChangeOldState:(AR3DCAPTURESTATETYPE)oldstate andNewState:(AR3DCAPTURESTATETYPE) newstate {
    if(newstate == AR3DCAPTURE_STATE_FILESAVE){
        //代表开始创建OBJ 这个过程放在后台h默默处理
        [[AppDelegate navigation] pushViewController:[ALScanFaceCompleteViewController new] animated:YES];
    }
}
- ( ALFaceSDK *)faceSDK
{
    if (!_faceSDK) {
        _faceSDK = [[ALFaceSDK alloc] init];
    }
    return _faceSDK;
}
@end
